/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.tile;

import com.vladmarica.energymeters.Util;
import com.vladmarica.energymeters.energy.EnergyTypes;
import com.vladmarica.energymeters.energy.storage.ForgeEnergyStorage;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityEnergyMeterFE
extends TileEntityEnergyMeterBase {
    private ForgeEnergyStorage inputEnergyStorage;
    private ForgeEnergyStorage outputEnergyStorage;

    public TileEntityEnergyMeterFE() {
        super(EnergyTypes.FE);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.inputEnergyStorage = new ForgeEnergyStorage(this, this.inputSide);
            this.outputEnergyStorage = new ForgeEnergyStorage(this, this.outputSide);
        }
    }

    @Override
    public int getEnergyScale() {
        return 1;
    }

    @Override
    public long receiveEnergy(long amount, boolean simulate, EnumFacing side) {
        int amountReceived;
        if (!this.isFullyConnected() || side != this.inputSide || this.isDisabled()) {
            return 0L;
        }
        BlockPos outputBlockPos = this.field_174879_c.func_177971_a(this.outputSide.func_176730_m());
        IEnergyStorage adjacentEnergyStorage = Util.getEnergyStorage(this.field_145850_b, outputBlockPos, this.outputSide.func_176734_d());
        if (adjacentEnergyStorage != null) {
            long amountToSend = this.rateLimit == -1 ? amount : Math.min(amount, (long)this.rateLimit);
            amountReceived = adjacentEnergyStorage.receiveEnergy((int)amountToSend, simulate);
        } else {
            amountReceived = 0;
        }
        if (!simulate) {
            this.totalEnergyTransferred += (long)amountReceived;
        }
        return amountReceived;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return side == this.inputSide;
    }

    @Override
    public boolean canEmitEnergy(EnumFacing side) {
        return side == this.outputSide;
    }

    @Override
    protected void checkConnections() {
        boolean connected = false;
        if (this.inputSide != null && this.outputSide != null) {
            BlockPos inputNeighbor = this.field_174879_c.func_177972_a(this.inputSide);
            BlockPos outputNeightbor = this.field_174879_c.func_177972_a(this.outputSide);
            IEnergyStorage inputEnergyStorage = Util.getEnergyStorage(this.field_145850_b, inputNeighbor, this.inputSide.func_176734_d());
            IEnergyStorage outputEnergyStorage = Util.getEnergyStorage(this.field_145850_b, outputNeightbor, this.outputSide.func_176734_d());
            boolean bl = connected = inputEnergyStorage != null && outputEnergyStorage != null && outputEnergyStorage.canReceive();
        }
        if (connected != this.fullyConnected) {
            this.fullyConnected = connected;
            this.notifyUpdate();
        }
    }

    @Override
    public void handleSideUpdateRequest(@Nullable EnumFacing inputSide, @Nullable EnumFacing outputSide) {
        this.inputEnergyStorage = new ForgeEnergyStorage(this, inputSide);
        this.outputEnergyStorage = new ForgeEnergyStorage(this, outputSide);
        super.handleSideUpdateRequest(inputSide, outputSide);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != null && this.doesSideAcceptConnection(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != null && this.doesSideAcceptConnection(facing)) {
            if (facing == this.inputSide) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.inputEnergyStorage);
            }
            if (facing == this.outputSide) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.outputEnergyStorage);
            }
            throw new RuntimeException("Attempted to get energy capability for invalid side: " + facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

