/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.network;

import io.netty.buffer.ByteBuf;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.tileentity.DoorFactoryTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class DoorFactoryMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public DoorFactoryMessage() {
        MalisisDoors.network.registerMessage((IMessageHandler)this, Packet.class, Side.SERVER);
    }

    public void process(Packet message, MessageContext ctx) {
        World world = IMalisisMessageHandler.getWorld((MessageContext)ctx);
        DoorFactoryTileEntity te = (DoorFactoryTileEntity)((Object)TileEntityUtils.getTileEntity(DoorFactoryTileEntity.class, (IBlockAccess)world, (BlockPos)message.pos));
        if (te == null) {
            return;
        }
        if (message.type == Packet.TYPE_DOORINFOS) {
            te.setCreate(message.isCreate);
            te.setDoorMovement(DoorRegistry.getMovement(message.movement));
            te.setDoorSound(DoorRegistry.getSound(message.sound));
            te.setOpeningTime(message.openTime);
            te.setAutoCloseTime(message.autoCloseTime);
            te.setRedstoneBehavior(DoorDescriptor.RedstoneBehavior.values()[message.redstoneBehavior]);
            te.setDoubleDoor(message.doubleDoor);
            te.setProximityDetection(message.proximityDetection);
            te.setCode(message.code);
        } else {
            te.createDoor();
        }
    }

    public static void sendDoorInformations(DoorFactoryTileEntity te) {
        Packet packet = new Packet(Packet.TYPE_DOORINFOS, te.func_174877_v());
        packet.setDoorInfos(te);
        MalisisDoors.network.sendToServer((IMessage)packet);
    }

    public static void sendCreateDoor(DoorFactoryTileEntity te) {
        Packet packet = new Packet(Packet.TYPE_CREATEDOOR, te.func_174877_v());
        MalisisDoors.network.sendToServer((IMessage)packet);
    }

    public static class Packet
    implements IMessage {
        private static int TYPE_DOORINFOS = 0;
        private static int TYPE_CREATEDOOR = 1;
        private BlockPos pos;
        private int type;
        private boolean isCreate;
        private String movement;
        private String sound;
        private int openTime;
        private int autoCloseTime;
        private int redstoneBehavior;
        private boolean doubleDoor;
        private boolean proximityDetection;
        private String code;

        public Packet() {
        }

        public Packet(int type, BlockPos pos) {
            this.type = type;
            this.pos = pos;
        }

        public void setDoorInfos(DoorFactoryTileEntity te) {
            String movement = DoorRegistry.getId(te.getDoorMovement());
            String sound = DoorRegistry.getId(te.getDoorSound());
            this.isCreate = te.isCreate();
            this.movement = movement;
            this.sound = sound;
            this.openTime = te.getOpeningTime();
            this.autoCloseTime = te.getAutoCloseTime();
            this.redstoneBehavior = te.getRedstoneBehavior().ordinal();
            this.doubleDoor = te.isDoubleDoor();
            this.proximityDetection = te.hasProximityDetection();
            this.code = te.getCode();
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.type = buf.readInt();
            if (this.type == TYPE_DOORINFOS) {
                this.isCreate = buf.readBoolean();
                this.movement = ByteBufUtils.readUTF8String((ByteBuf)buf);
                if (this.movement.equals("")) {
                    this.movement = null;
                }
                this.sound = ByteBufUtils.readUTF8String((ByteBuf)buf);
                if (this.sound.equals("")) {
                    this.sound = null;
                }
                this.openTime = buf.readInt();
                this.autoCloseTime = buf.readInt();
                this.redstoneBehavior = buf.readInt();
                this.doubleDoor = buf.readBoolean();
                this.proximityDetection = buf.readBoolean();
                this.code = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(this.type);
            if (this.type == TYPE_DOORINFOS) {
                buf.writeBoolean(this.isCreate);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.movement != null ? this.movement : ""));
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.sound != null ? this.sound : ""));
                buf.writeInt(this.openTime);
                buf.writeInt(this.autoCloseTime);
                buf.writeInt(this.redstoneBehavior);
                buf.writeBoolean(this.doubleDoor);
                buf.writeBoolean(this.proximityDetection);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.code != null ? this.code : ""));
            }
        }
    }
}

