/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.alloy;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.alloy.ItemBlockAlloy;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.util.ClientUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAlloy
extends BlockEio<TileEntityEio>
implements IAdvancedTooltipProvider,
IHaveRenderers {
    @Nonnull
    public static final PropertyEnum<Alloy> VARIANT = PropertyEnum.func_177709_a((String)"variant", Alloy.class);

    public static BlockAlloy create(@Nonnull IModObject modObject) {
        BlockAlloy res = new BlockAlloy(modObject);
        res.init();
        return res;
    }

    private BlockAlloy(@Nonnull IModObject modObject) {
        super(modObject, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(EnderIOTab.tabEnderIOMaterials);
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Override
    public ItemBlockAlloy createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new ItemBlockAlloy(this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

            public void apply(@Nonnull Alloy alloy) {
                ClientUtil.regRenderer((Block)BlockAlloy.this, Alloy.getMetaFromType(alloy), VARIANT.func_177701_a() + "=" + VARIANT.func_177702_a((Enum)alloy));
            }
        });
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return ((Alloy)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Alloy.getTypeFromMeta(meta)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((Alloy)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public float func_176195_g(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos) {
        return ((Alloy)((Object)bs.func_177229_b(VARIANT))).getHardness();
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity exploder, @Nonnull Explosion explosion) {
        return this.func_176195_g(world.func_180495_p(pos), world, pos) * 2.0f;
    }

    public boolean isBeaconBase(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull BlockPos beacon) {
        return true;
    }

    @Override
    public boolean canBeWrenched() {
        return false;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        list.add(Lang.BETTER_WITH_BACON.get());
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }
}

