/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.delta;

import buildcraft.lib.delta.DeltaManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;

public class DeltaInt {
    public final String name;
    public final DeltaManager.EnumNetworkVisibility visibility;
    private int staticStartValue = 0;
    private int staticEndValue = 0;
    private double dynamicValueLast = 0.0;
    private double dynamicValueThis;
    public final List<DeltaIntEntry> changingEntries = new ArrayList<DeltaIntEntry>();
    private final DeltaManager manager;
    private long tick = 0L;

    public DeltaInt(String name, DeltaManager.EnumNetworkVisibility visibility, DeltaManager manager) {
        this.name = name;
        this.visibility = visibility;
        this.manager = manager;
    }

    public void tick() {
        Iterator<DeltaIntEntry> iter = this.changingEntries.iterator();
        while (iter.hasNext()) {
            DeltaIntEntry delta = iter.next();
            if (this.tick >= delta.endTick) {
                iter.remove();
                this.staticEndValue += delta.delta;
                continue;
            }
            if (this.tick < delta.startTick || delta.hasStarted) continue;
            this.staticStartValue += delta.delta;
            delta.hasStarted = true;
        }
        double dynamic = this.staticEndValue;
        for (DeltaIntEntry entry : this.changingEntries) {
            if (this.tick < entry.startTick) continue;
            long duration = entry.endTick - entry.startTick;
            long elapsed = this.tick - entry.startTick;
            double interp = (double)elapsed / (double)duration;
            dynamic += (double)entry.delta * interp;
        }
        this.dynamicValueLast = this.dynamicValueThis;
        this.dynamicValueThis = dynamic;
        ++this.tick;
    }

    public double getDynamic(float partialTicks) {
        if (partialTicks <= 0.0f) {
            return this.dynamicValueLast;
        }
        if (partialTicks >= 1.0f) {
            return this.dynamicValueThis;
        }
        double a = this.dynamicValueLast * (double)(1.0f - partialTicks);
        double b = this.dynamicValueThis * (double)partialTicks;
        return a + b;
    }

    public int getStatic(boolean start) {
        return start ? this.staticStartValue : this.staticEndValue;
    }

    void receiveData(DeltaManager.EnumDeltaMessage type, PacketBuffer buffer) {
        if (type == DeltaManager.EnumDeltaMessage.ADD_SINGLE) {
            long start = buffer.readLong();
            long end = buffer.readLong();
            int delta = buffer.readInt();
            DeltaIntEntry entry = new DeltaIntEntry(start + this.tick, end + this.tick, delta);
            this.changingEntries.add(entry);
        } else if (type == DeltaManager.EnumDeltaMessage.SET_VALUE) {
            int value;
            this.changingEntries.clear();
            this.staticStartValue = value = buffer.readInt();
            this.staticEndValue = value;
            this.dynamicValueLast = value;
            this.dynamicValueThis = value;
        } else if (type == DeltaManager.EnumDeltaMessage.CURRENT_STATE) {
            this.staticStartValue = buffer.readInt();
            this.staticEndValue = buffer.readInt();
            this.changingEntries.clear();
            int count = buffer.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                long start = buffer.readLong() + this.tick;
                long end = buffer.readLong() + this.tick;
                int delta = buffer.readInt();
                DeltaIntEntry entry = new DeltaIntEntry(start, end, delta);
                entry.hasStarted = buffer.readBoolean();
                this.changingEntries.add(entry);
            }
        }
    }

    void writeState(PacketBuffer buffer) {
        buffer.writeInt(this.staticStartValue);
        buffer.writeInt(this.staticEndValue);
        buffer.writeShort(this.changingEntries.size());
        for (DeltaIntEntry delta : this.changingEntries) {
            buffer.writeLong(delta.startTick - this.tick);
            buffer.writeLong(delta.endTick - this.tick);
            buffer.writeInt(delta.delta);
            buffer.writeBoolean(delta.hasStarted);
        }
    }

    public void addDelta(long start, long end, int delta) {
        DeltaIntEntry entry = new DeltaIntEntry(start + this.tick, end + this.tick, delta);
        this.changingEntries.add(entry);
        this.manager.sendDeltaMessage(DeltaManager.EnumDeltaMessage.ADD_SINGLE, this, buffer -> {
            buffer.writeLong(entry.startTick - this.tick);
            buffer.writeLong(entry.endTick - this.tick);
            buffer.writeInt(entry.delta);
        });
    }

    public void setValue(int value) {
        this.changingEntries.clear();
        this.staticStartValue = value;
        this.staticEndValue = value;
        this.dynamicValueLast = value;
        this.dynamicValueThis = value;
        this.manager.sendDeltaMessage(DeltaManager.EnumDeltaMessage.SET_VALUE, this, buffer -> buffer.writeInt(value));
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.tick = nbt.func_74763_f("tick");
        this.staticStartValue = nbt.func_74762_e("static-start");
        this.staticEndValue = nbt.func_74762_e("static-end");
        this.changingEntries.clear();
        NBTTagList list = nbt.func_150295_c("changing", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entryNbt = list.func_150305_b(i);
            long start = entryNbt.func_74763_f("start");
            long end = entryNbt.func_74763_f("end");
            int delta = entryNbt.func_74762_e("delta");
            DeltaIntEntry entry = new DeltaIntEntry(start, end, delta);
            entry.hasStarted = entryNbt.func_74767_n("started");
            this.changingEntries.add(entry);
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("tick", this.tick);
        nbt.func_74768_a("static-start", this.staticStartValue);
        nbt.func_74768_a("static-end", this.staticEndValue);
        NBTTagList list = new NBTTagList();
        for (DeltaIntEntry entry : this.changingEntries) {
            NBTTagCompound entryNbt = new NBTTagCompound();
            entryNbt.func_74772_a("start", entry.startTick);
            entryNbt.func_74772_a("end", entry.endTick);
            entryNbt.func_74768_a("delta", entry.delta);
            entryNbt.func_74757_a("started", entry.hasStarted);
            list.func_74742_a((NBTBase)entryNbt);
        }
        nbt.func_74782_a("changing", (NBTBase)list);
        return nbt;
    }

    private static class DeltaIntEntry {
        private boolean hasStarted = false;
        private final long startTick;
        private final long endTick;
        private final int delta;

        public DeltaIntEntry(long startTick, long endTick, int delta) {
            this.startTick = startTick;
            this.endTick = endTick;
            this.delta = delta;
        }
    }
}

