/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.atmosphere;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHighPressure;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHighPressureNoOxygen;
import zmaster587.advancedRocketry.atmosphere.AtmosphereLowOxygen;
import zmaster587.advancedRocketry.atmosphere.AtmosphereNoOxygen;
import zmaster587.advancedRocketry.atmosphere.AtmosphereSuperHighPressure;
import zmaster587.advancedRocketry.atmosphere.AtmosphereSuperHighPressureNoOxygen;
import zmaster587.advancedRocketry.atmosphere.AtmosphereSuperheated;
import zmaster587.advancedRocketry.atmosphere.AtmosphereSuperheatedNoOxygen;
import zmaster587.advancedRocketry.atmosphere.AtmosphereVacuum;
import zmaster587.advancedRocketry.atmosphere.AtmosphereVeryHot;
import zmaster587.advancedRocketry.atmosphere.AtmosphereVeryHotNoOxygen;

public class AtmosphereType
implements IAtmosphere {
    public static final AtmosphereType AIR = new AtmosphereType(false, true, "air");
    public static final AtmosphereType PRESSURIZEDAIR = new AtmosphereType(false, true, true, "PressurizedAir");
    public static final AtmosphereType LOWOXYGEN = new AtmosphereLowOxygen(true, false, false, "lowO2");
    public static final AtmosphereType VACUUM = new AtmosphereVacuum();
    public static final AtmosphereType HIGHPRESSURE = new AtmosphereHighPressure(true, false, true, "HighPressure");
    public static final AtmosphereType SUPERHIGHPRESSURE = new AtmosphereSuperHighPressure(true, false, true, "SuperHighPressure");
    public static final AtmosphereType VERYHOT = new AtmosphereVeryHot(true, false, true, "VeryHot");
    public static final AtmosphereType SUPERHEATED = new AtmosphereSuperheated(true, false, true, "Superheated");
    public static final AtmosphereType NOO2 = new AtmosphereNoOxygen(true, false, false, "NoO2");
    public static final AtmosphereType HIGHPRESSURENOO2 = new AtmosphereHighPressureNoOxygen(true, false, false, "HighPressureNoO2");
    public static final AtmosphereType SUPERHIGHPRESSURENOO2 = new AtmosphereSuperHighPressureNoOxygen(true, false, false, "SuperHighPressureNoO2");
    public static final AtmosphereType VERYHOTNOO2 = new AtmosphereVeryHotNoOxygen(true, false, false, "VeryHotNoO2");
    public static final AtmosphereType SUPERHEATEDNOO2 = new AtmosphereSuperheatedNoOxygen(true, false, false, "SuperheatedNoOxygen");
    private boolean allowsCombustion;
    private boolean isBreathable;
    private boolean canTick;
    private String name;

    public AtmosphereType(boolean canTick, boolean isBreathable, String name) {
        this.allowsCombustion = isBreathable;
        this.isBreathable = isBreathable;
        this.canTick = canTick;
        this.name = name;
    }

    public AtmosphereType(boolean canTick, boolean isBreathable, boolean allowsCombustion, String name) {
        this(canTick, isBreathable, name);
        this.allowsCombustion = allowsCombustion;
    }

    @Override
    public boolean canTick() {
        return this.canTick;
    }

    @Override
    public boolean isImmune(EntityLivingBase player) {
        return this.isBreathable;
    }

    @Override
    public boolean isImmune(Class<? extends Entity> clazz) {
        return this.isBreathable() || ARConfiguration.getCurrentConfig().bypassEntity.contains(clazz);
    }

    @Override
    public boolean isBreathable() {
        return this.isBreathable;
    }

    @Override
    public boolean allowsCombustion() {
        return this.allowsCombustion;
    }

    public void setIsBreathable(boolean isBreathable) {
        this.isBreathable = isBreathable;
    }

    public void setAllowsCombustion(boolean allowsCombustion) {
        this.allowsCombustion = allowsCombustion;
    }

    @Override
    public String getDisplayMessage() {
        return "";
    }

    @Override
    public void onTick(EntityLivingBase player) {
    }

    @Override
    public String getUnlocalizedName() {
        return this.name;
    }

    static {
        AtmosphereRegister.getInstance().registerAtmosphere(AIR);
        AtmosphereRegister.getInstance().registerAtmosphere(PRESSURIZEDAIR);
        AtmosphereRegister.getInstance().registerAtmosphere(VACUUM);
        AtmosphereRegister.getInstance().registerAtmosphere(LOWOXYGEN);
        AtmosphereRegister.getInstance().registerAtmosphere(HIGHPRESSURE);
        AtmosphereRegister.getInstance().registerAtmosphere(SUPERHIGHPRESSURE);
        AtmosphereRegister.getInstance().registerAtmosphere(VERYHOT);
        AtmosphereRegister.getInstance().registerAtmosphere(SUPERHEATED);
        AtmosphereRegister.getInstance().registerAtmosphere(NOO2);
        AtmosphereRegister.getInstance().registerAtmosphere(HIGHPRESSURENOO2);
        AtmosphereRegister.getInstance().registerAtmosphere(SUPERHIGHPRESSURENOO2);
        AtmosphereRegister.getInstance().registerAtmosphere(VERYHOTNOO2);
        AtmosphereRegister.getInstance().registerAtmosphere(SUPERHEATEDNOO2);
    }
}

