/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.CollectorTileRenderer;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.screen.BasicCollectorScreen;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        ClientRegistry.bindTileEntitySpecialRenderer(CollectorTile.class, (TileEntitySpecialRenderer)new CollectorTileRenderer());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ItemCollectors.basic_collector), (int)0, (ModelResourceLocation)new ModelResourceLocation(ItemCollectors.basic_collector.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ItemCollectors.advanced_collector), (int)0, (ModelResourceLocation)new ModelResourceLocation(ItemCollectors.advanced_collector.getRegistryName(), "inventory"));
    }

    public static void openBasicCollectorScreen(BlockPos pos) {
        ClientUtils.displayScreen((GuiScreen)new BasicCollectorScreen(pos));
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void onBlockHighlight(DrawBlockHighlightEvent e) {
            if (e.getTarget().field_72313_a != RayTraceResult.Type.BLOCK || e.getTarget().func_178782_a() == null) {
                return;
            }
            World world = ClientUtils.getWorld();
            TileEntity tile = world.func_175625_s(e.getTarget().func_178782_a());
            if (tile instanceof CollectorTile) {
                GlStateManager.func_179094_E();
                Vec3d camera = RenderUtils.getCameraPosition();
                GlStateManager.func_179137_b((double)(-camera.field_72450_a), (double)(-camera.field_72448_b), (double)(-camera.field_72449_c));
                AxisAlignedBB area = ((CollectorTile)tile).getAffectedArea().func_186662_g((double)0.05f);
                Random random = new Random(tile.func_174877_v().hashCode());
                float red = random.nextFloat();
                float green = random.nextFloat();
                float blue = random.nextFloat();
                float alpha = 0.3f;
                RenderUtils.renderBox((AxisAlignedBB)area, (float)red, (float)green, (float)blue);
                RenderUtils.renderBoxSides((AxisAlignedBB)area, (float)red, (float)green, (float)blue, (float)alpha);
                GlStateManager.func_179121_F();
            }
        }
    }
}

