/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.ToolType;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.itemcollectors.ClientProxy;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.ItemCollectors;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CollectorBlock
extends BaseBlock {
    public static final PropertyEnum<EnumFacing> DIRECTION = BlockDirectional.field_176387_N;
    private static final BlockShape SHAPE = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), BlockShape.createBlockShape((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)5.0, (double)6.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)10.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)10.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)});
    private static final BlockShape[] SHAPES = new BlockShape[6];
    private final Supplier<CollectorTile> tileSupplier;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;

    public CollectorBlock(String registryName, Supplier<CollectorTile> tileSupplier, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(registryName, false, BaseBlock.Properties.create((Material)Material.field_151576_e, (MapColor)MapColor.field_151646_E).harvestTool(ToolType.PICKAXE).harvestLevel(1).hardnessAndResistance(5.0f, 1200.0f));
        this.tileSupplier = tileSupplier;
        this.maxRange = maxRange;
        this.hasFilter = hasFilter;
        this.func_149647_a(CreativeTabs.field_78027_g);
        this.func_180632_j(this.func_176223_P().func_177226_a(DIRECTION, (Comparable)EnumFacing.DOWN));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand handIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K && !this.hasFilter.get().booleanValue()) {
            ClientProxy.openBasicCollectorScreen(pos);
        } else if (!worldIn.field_72995_K && this.hasFilter.get().booleanValue()) {
            player.openGui((Object)ItemCollectors.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SHAPES[((EnumFacing)state.func_177229_b(DIRECTION)).func_176745_a()].simplify();
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        for (AxisAlignedBB box : SHAPES[((EnumFacing)state.func_177229_b(DIRECTION)).func_176745_a()].toBoxes()) {
            CollectorBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == state.func_177229_b(DIRECTION) ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return (TileEntity)this.tileSupplier.get();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextComponents.translation((String)("itemcollectors." + (this.hasFilter.get() != false ? "advanced" : "basic") + "_collector.info"), (Object[])new Object[]{this.maxRange.get()}).color(TextFormatting.AQUA).format());
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)facing.func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(DIRECTION)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    static {
        CollectorBlock.SHAPES[EnumFacing.DOWN.func_176745_a()] = SHAPE;
        CollectorBlock.SHAPES[EnumFacing.UP.func_176745_a()] = SHAPE.rotate(EnumFacing.Axis.X).rotate(EnumFacing.Axis.X);
        CollectorBlock.SHAPES[EnumFacing.NORTH.func_176745_a()] = SHAPE.rotate(EnumFacing.Axis.X).rotate(EnumFacing.Axis.Y).rotate(EnumFacing.Axis.Y);
        CollectorBlock.SHAPES[EnumFacing.EAST.func_176745_a()] = SHAPE.rotate(EnumFacing.Axis.X).rotate(EnumFacing.Axis.Y).rotate(EnumFacing.Axis.Y).rotate(EnumFacing.Axis.Y);
        CollectorBlock.SHAPES[EnumFacing.SOUTH.func_176745_a()] = SHAPE.rotate(EnumFacing.Axis.X);
        CollectorBlock.SHAPES[EnumFacing.WEST.func_176745_a()] = SHAPE.rotate(EnumFacing.Axis.X).rotate(EnumFacing.Axis.Y);
    }
}

