/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.itemcollectors.CollectorBlock;
import com.supermartijn642.itemcollectors.ItemCollectorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CollectorTile
extends BaseTileEntity
implements ITickable {
    private static final int MIN_RANGE = 1;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;
    public int rangeX;
    public int rangeY;
    public int rangeZ;
    public final List<ItemStack> filter = new ArrayList<ItemStack>(9);
    public boolean filterWhitelist;
    public boolean filterDurability = true;
    public boolean showArea = false;

    public static CollectorTile basicTile() {
        return new BasicCollectorTile();
    }

    public static CollectorTile advancedTile() {
        return new AdvancedCollectorTile();
    }

    public CollectorTile(Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = (int)Math.ceil((float)maxRange.get().intValue() / 2.0f);
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(ItemStack.field_190927_a);
        }
    }

    public void func_73660_a() {
        this.getOutputItemHandler().ifPresent(itemHandler -> {
            if (itemHandler.getSlots() <= 0) {
                return;
            }
            AxisAlignedBB area = this.getAffectedArea();
            List items = this.field_145850_b.func_175647_a(EntityItem.class, area, item -> {
                if (!item.func_70089_S() || item.getEntityData().func_74764_b("PreventRemoteMovement") && !item.getEntityData().func_74764_b("AllowMachineRemoteMovement")) {
                    return false;
                }
                if (!this.hasFilter.get().booleanValue()) {
                    return true;
                }
                ItemStack stack = item.func_92059_d();
                if (stack.func_190926_b()) {
                    return false;
                }
                for (int i = 0; i < 9; ++i) {
                    ItemStack filter = this.filter.get(i);
                    if (!(this.filterDurability ? ItemStack.func_179545_c((ItemStack)filter, (ItemStack)stack) : ItemStack.func_185132_d((ItemStack)filter, (ItemStack)stack)) || !ItemStack.func_77970_a((ItemStack)filter, (ItemStack)stack)) continue;
                    return this.filterWhitelist;
                }
                return !this.filterWhitelist;
            });
            block0: for (EntityItem entity : items) {
                ItemStack stack = entity.func_92059_d().func_77946_l();
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    if (!itemHandler.isItemValid(slot, stack) || !(stack = itemHandler.insertItem(slot, stack, false)).func_190926_b()) continue;
                    entity.func_92058_a(ItemStack.field_190927_a);
                    entity.func_70106_y();
                    continue block0;
                }
                entity.func_92058_a(stack);
            }
        });
    }

    public AxisAlignedBB getAffectedArea() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.rangeX, -this.rangeY, -this.rangeZ), this.field_174879_c.func_177982_a(this.rangeX + 1, this.rangeY + 1, this.rangeZ + 1));
    }

    private Optional<IItemHandler> getOutputItemHandler() {
        IBlockState state = this.getBlockState();
        if (!state.func_177227_a().contains(CollectorBlock.DIRECTION)) {
            return Optional.empty();
        }
        EnumFacing direction = (EnumFacing)state.func_177229_b(CollectorBlock.DIRECTION);
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
        if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d())) {
            return Optional.empty();
        }
        return Optional.ofNullable(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()));
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    public void setShowArea(boolean showArea) {
        if (this.showArea != showArea) {
            this.showArea = showArea;
            this.dataChanged();
        }
    }

    protected NBTTagCompound writeData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("rangeX", this.rangeX);
        tag.func_74768_a("rangeY", this.rangeY);
        tag.func_74768_a("rangeZ", this.rangeZ);
        for (int i = 0; i < 9; ++i) {
            if (this.filter.get(i).func_190926_b()) continue;
            tag.func_74782_a("filter" + i, (NBTBase)this.filter.get(i).func_77955_b(new NBTTagCompound()));
        }
        tag.func_74757_a("filterWhitelist", this.filterWhitelist);
        tag.func_74757_a("filterDurability", this.filterDurability);
        tag.func_74757_a("showArea", this.showArea);
        return tag;
    }

    protected void readData(NBTTagCompound tag) {
        if (tag.func_74764_b("rangeX")) {
            this.rangeX = tag.func_74762_e("rangeX");
        }
        if (tag.func_74764_b("rangeY")) {
            this.rangeY = tag.func_74762_e("rangeY");
        }
        if (tag.func_74764_b("rangeZ")) {
            this.rangeZ = tag.func_74762_e("rangeZ");
        }
        for (int i = 0; i < 9; ++i) {
            this.filter.set(i, tag.func_74764_b("filter" + i) ? new ItemStack(tag.func_74775_l("filter" + i)) : ItemStack.field_190927_a);
        }
        this.filterWhitelist = tag.func_74764_b("filterWhitelist") && tag.func_74767_n("filterWhitelist");
        this.filterDurability = tag.func_74764_b("filterDurability") && tag.func_74767_n("filterDurability");
        this.showArea = tag.func_74764_b("showArea") && tag.func_74767_n("showArea");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getAffectedArea();
    }

    public static class AdvancedCollectorTile
    extends CollectorTile {
        public AdvancedCollectorTile() {
            super(ItemCollectorsConfig.advancedCollectorMaxRange, ItemCollectorsConfig.advancedCollectorFilter);
        }
    }

    public static class BasicCollectorTile
    extends CollectorTile {
        public BasicCollectorTile() {
            super(ItemCollectorsConfig.basicCollectorMaxRange, ItemCollectorsConfig.basicCollectorFilter);
        }
    }
}

