## RFID Reader Block

![](https://i.imgur.com/LZ8oZKI.png)

RFID Reader Block allows you to read RFID Cards in a players inventory

Can be used as Upgrade for Drones/Microcontrollers/Robots/Tablets

### Methods:
```lua
rfid = require("component").os_rfidreader

-- Scans for all entites for RFIDs within range default is 16 blocks
rfid.scan(optional int:1-64) 
```
If you specify an integer it will scan that area, large areas can cause lag.
This will queue a signal with the name rfidData 4 parameters will be returned,: uuid, playerName, distance, data.
It will also return the data in a table.
The max range is configurable in the mod's config file, though the maximum is 64 blocks even there.
### Example Program:
```lua
output = component.os_rfidReader.scan(10)
for k, v in pairs(output[1]) do
    print(k, v)
end
```
It would return:

    uuid    (uuid)
    data    (data)
    player  (player)
    range   (range)
