/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.mjr.mjrlegendslib.client.model.IItemMeshDefinitionCustom;
import com.mjr.mjrlegendslib.client.model.ModelTransformWrapper;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientUtilities {
    public static void addVariants(String modID, String name, String ... variants) {
        Item itemBlockVariants = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modID, name));
        ResourceLocation[] variants0 = new ResourceLocation[variants.length];
        for (int i = 0; i < variants.length; ++i) {
            variants0[i] = new ResourceLocation(modID + ":" + variants[i]);
        }
        ModelBakery.registerItemVariants((Item)itemBlockVariants, (ResourceLocation[])variants0);
    }

    public static void registerBlockJson(String texturePrefix, Block block, int meta, String name) {
        ClientUtilities.registerModel(Item.func_150898_a((Block)block), meta, new ModelResourceLocation(texturePrefix + name, "inventory"));
    }

    public static void registerBlockJson(String texturePrefix, Block block) {
        ClientUtilities.registerBlockJson(texturePrefix, block, 0, block.func_149739_a().substring(5));
    }

    public static void registerItemJson(String texturePrefix, Item item) {
        ClientUtilities.registerItemJson(texturePrefix, item, 0, item.func_77658_a().substring(5));
    }

    public static void registerItemJson(String texturePrefix, Item item, int meta) {
        ClientUtilities.registerItemJson(texturePrefix, item, meta, item.func_77658_a().substring(5));
    }

    public static void registerItemJson(String texturePrefix, Item item, String[] items) {
        for (int i = 0; i < items.length; ++i) {
            ClientUtilities.registerItemJson(texturePrefix, item, i, items[i]);
        }
    }

    public static void registerItemJson(String texturePrefix, Item item, String[] items, boolean halfAmount) {
        int times = halfAmount ? items.length / 2 : items.length;
        for (int i = 0; i < times; ++i) {
            ClientUtilities.registerItemJson(texturePrefix, item, i, items[i]);
        }
    }

    public static void registerItemJson(String texturePrefix, Item item, String prefix, String[] items) {
        for (int i = 0; i < items.length; ++i) {
            ClientUtilities.registerItemJson(texturePrefix, item, i, prefix + items[i]);
        }
    }

    public static void registerItemJson(String texturePrefix, Item item, int meta, String name) {
        ClientUtilities.registerModel(item, meta, new ModelResourceLocation(texturePrefix + name, "inventory"));
    }

    public static void registerItemJson(String texturePrefix, Item item, String name) {
        ClientUtilities.registerItemJson(texturePrefix, item, 0, name);
    }

    public static void registerItemJson(String texturePrefix, ItemStack item, String name) {
        ClientUtilities.registerItemJson(texturePrefix, item.func_77973_b(), item.func_77960_j(), name);
    }

    public static void registerItemJson(String texturePrefix, List<Item> items, String name) {
        for (Item item : items) {
            ClientUtilities.registerItemJson(texturePrefix, item, name);
        }
    }

    public static void registerItemJson(String texturePrefix, List<Item> items) {
        for (Item item : items) {
            ClientUtilities.registerItemJson(texturePrefix, item, item.func_77658_a().substring(5));
        }
    }

    public static void replaceModelDefaultBlock(String modID, ModelBakeEvent event, String loc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, String ... variants) {
        ClientUtilities.replaceModelDefault(modID, event, loc, "block/" + loc + ".obj", visibleGroups, clazz, (IModelState)TRSRTransformation.identity(), variants);
    }

    public static void replaceModelDefaultBlock(String modID, ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, String ... variants) {
        ClientUtilities.replaceModelDefault(modID, event, resLoc, "block/" + objLoc, visibleGroups, clazz, (IModelState)TRSRTransformation.identity(), variants);
    }

    public static void replaceModelDefaultBlock(String modID, ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, IModelState parentState, String ... variants) {
        ClientUtilities.replaceModelDefault(modID, event, resLoc, "block/" + objLoc, visibleGroups, clazz, parentState, variants);
    }

    public static void replaceModelDefault(String modID, ModelBakeEvent event, String loc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, String ... variants) {
        ClientUtilities.replaceModelDefault(modID, event, loc, loc + ".obj", visibleGroups, clazz, (IModelState)TRSRTransformation.identity(), variants);
    }

    public static void replaceModelDefault(String modID, ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, String ... variants) {
        ClientUtilities.replaceModelDefault(modID, event, resLoc, objLoc, visibleGroups, clazz, (IModelState)TRSRTransformation.identity(), variants);
    }

    public static void replaceModelDefault(String modID, ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, IModelState parentState, String ... variants) {
        OBJModel model;
        if (variants.length == 0) {
            variants = new String[]{"inventory"};
        }
        try {
            model = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modID, objLoc));
            model = (OBJModel)model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        for (String variant : variants) {
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(modID + ":" + resLoc, variant);
            IBakedModel object = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelResourceLocation);
            if (object == null) continue;
            if (!variant.equals("inventory")) {
                parentState = TRSRTransformation.identity();
            }
            IBakedModel newModel = model.bake((IModelState)new OBJModel.OBJState(visibleGroups, false, parentState), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
            if (clazz != null) {
                try {
                    newModel = clazz.getConstructor(IBakedModel.class).newInstance(newModel);
                }
                catch (Exception e) {
                    MessageUtilities.fatalErrorMessageToLog("mjrlegendslib", "ItemModel constructor problem for " + modelResourceLocation);
                    e.printStackTrace();
                }
            }
            event.getModelRegistry().func_82595_a((Object)modelResourceLocation, (Object)newModel);
        }
    }

    public static void registerOBJInstance(String modID) {
        OBJLoader.INSTANCE.addDomain(modID);
    }

    public static void registerModel(Item item, int metadata, ModelResourceLocation model) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)model);
    }

    public static void registerModel(Block block, int metadata, ModelResourceLocation model) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)metadata, (ModelResourceLocation)model);
    }

    public static void registerModel(String texturePrefix, Block block, int meta, String name) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(texturePrefix + name, "inventory");
        ClientUtilities.registerModel(block, meta, modelResourceLocation);
    }

    public static void registerModel(String texturePrefix, Item item, int meta, String name) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(texturePrefix + name, "inventory");
        ClientUtilities.registerModel(item, meta, modelResourceLocation);
    }

    public static void registerModel(String texturePrefix, Item item, String name) {
        ClientUtilities.registerModel(texturePrefix, item, 0, name);
    }

    public static void registerModel(String texturePrefix, Block block, String name) {
        ClientUtilities.registerModel(texturePrefix, block, 0, name);
    }

    public static void registerModel(String texturePrefix, Item item, String name, int amountOfItems) {
        for (int i = 0; i < amountOfItems; ++i) {
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(texturePrefix + name, "inventory");
            ClientUtilities.registerModel(item, i, modelResourceLocation);
        }
    }

    public static void registerModel(String texturePrefix, Block block, String name, int amountOfItems) {
        for (int i = 0; i < amountOfItems; ++i) {
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(texturePrefix + name, "inventory");
            ClientUtilities.registerModel(block, i, modelResourceLocation);
        }
    }

    public static void registerFluidVariant(String fluid, Block fluidBlock) {
        final ModelResourceLocation location = new ModelResourceLocation(fluid, "fluid");
        Item item = Item.func_150898_a((Block)fluidBlock);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(fluid)});
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)IItemMeshDefinitionCustom.create(stack -> location));
        ModelLoader.setCustomStateMapper((Block)fluidBlock, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return location;
            }
        });
    }

    public static <T extends TileEntity> void registerTileEntityRenderer(Class<T> tileEntityClass, TileEntitySpecialRenderer<? super T> specialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileEntityClass, specialRenderer);
    }

    public static <T extends Entity> void registerEntityRenderer(Class<T> entityClass, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory);
    }

    public static void registerKeyBinding(KeyBinding key) {
        ClientRegistry.registerKeyBinding((KeyBinding)key);
    }

    public static void registerTexture(String texturePrefix, TextureStitchEvent.Pre event, String texture) {
        event.getMap().func_174942_a(new ResourceLocation(texturePrefix + "model/" + texture));
    }
}

