/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.util;

import com.mjr.mjrlegendslib.util.MCUtilities;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerUtilties {
    public static EntityPlayerMP getPlayerFromUUID(String player) {
        return PlayerUtilties.getPlayerFromUUID(UUID.fromString(player));
    }

    public static EntityPlayerMP getPlayerFromUUID(UUID player) {
        return (EntityPlayerMP)FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(player);
    }

    public static String getUsernameFromUUID(UUID player) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(player).getName();
    }

    public static String getUsernameFromUUID(String player) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(UUID.fromString(player)).getName();
    }

    public static void sendMessage(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public static boolean compareUUIDs(String uuid1, String uuid2) {
        return uuid1.equalsIgnoreCase(uuid2);
    }

    public static boolean compareUUIDs(UUID uuid1, UUID uuid2) {
        return uuid1.toString().equalsIgnoreCase(uuid2.toString());
    }

    public static boolean compareUsernameToUUID(String username, UUID uuid) {
        return username.equalsIgnoreCase(PlayerUtilties.getUsernameFromUUID(uuid));
    }

    public static boolean compareUUIDToUsername(UUID uuid, String username) {
        return PlayerUtilties.getUsernameFromUUID(uuid).equalsIgnoreCase(username);
    }

    public static boolean compareUsernameToUUID(String username, String uuid) {
        return username.equalsIgnoreCase(PlayerUtilties.getUsernameFromUUID(uuid));
    }

    public static boolean compareUUIDToUsername(String uuid, String username) {
        return PlayerUtilties.getUsernameFromUUID(uuid).equalsIgnoreCase(username);
    }

    public static boolean isPlayerOnlineByUsername(String username) {
        boolean online = false;
        for (String player : MCUtilities.getServer().func_71213_z()) {
            if (!player.equalsIgnoreCase(player)) continue;
            online = true;
        }
        return online;
    }

    public static boolean isPlayerOnlineByUUID(UUID UUID2) {
        boolean online = false;
        for (String player : MCUtilities.getServer().func_71213_z()) {
            if (!PlayerUtilties.compareUUIDToUsername(UUID2, player)) continue;
            online = true;
        }
        return online;
    }

    public static boolean isPlayerOnlineByUUID(String UUID2) {
        boolean online = false;
        for (String player : MCUtilities.getServer().func_71213_z()) {
            if (!PlayerUtilties.compareUUIDToUsername(UUID2, player)) continue;
            online = true;
        }
        return online;
    }
}

