/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemconfig;

import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IntegerConfigField
implements IItemConfigField {
    protected final String name;
    protected String description;
    private IItemConfigField.EnumControlType controlType;
    protected int minValue;
    protected int maxValue;
    protected int value;
    private String extension = "";
    private String prefix = "";

    public IntegerConfigField(String name, int defaultValue, int minValue, int maxValue, String description, IItemConfigField.EnumControlType controlType) {
        this.name = name;
        this.value = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.description = description;
        this.controlType = controlType;
    }

    public IntegerConfigField setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public IntegerConfigField setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnlocalizedName() {
        return "config.field." + this.getName() + ".entry";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getReadableValue() {
        return this.prefix + String.valueOf(this.value) + this.extension;
    }

    @Override
    public String getValueFraction(double percent) {
        return String.valueOf((int)((double)this.minValue + percent * (double)(this.maxValue - this.minValue))) + this.extension;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Integer getMin() {
        return this.minValue;
    }

    @Override
    public Integer getMax() {
        return this.maxValue;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public double getFractionalValue() {
        return (double)(this.value - this.minValue) / (double)(this.maxValue - this.minValue);
    }

    @Override
    public void handleButton(IItemConfigField.EnumButton button, int data) {
        switch (button) {
            case MINUS1: {
                --this.value;
                break;
            }
            case MINUS2: {
                this.value -= 10;
                break;
            }
            case MINUS3: {
                this.value -= 100;
                break;
            }
            case PLUS1: {
                ++this.value;
                break;
            }
            case PLUS2: {
                this.value += 10;
                break;
            }
            case PLUS3: {
                this.value += 100;
                break;
            }
            case MIN: {
                this.value = this.minValue;
                break;
            }
            case MAX: {
                this.value = this.maxValue;
                break;
            }
            case SELECTION: {
                this.value = data;
                break;
            }
            case SLIDER: {
                double range = this.maxValue - this.minValue;
                double pos = (double)data / 10000.0 * range;
                this.value = (int)((double)this.minValue + pos);
            }
        }
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        } else if (this.value < this.minValue) {
            this.value = this.minValue;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a(this.name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.value = compound.func_74762_e(this.name);
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
            this.writeToNBT(compound);
        } else if (this.value < this.minValue) {
            this.value = this.minValue;
            this.writeToNBT(compound);
        }
    }

    @Override
    public IItemConfigField.EnumControlType getType() {
        return this.controlType;
    }

    @Override
    public Map<Integer, String> getValues() {
        LinkedHashMap<Integer, String> list = new LinkedHashMap<Integer, String>();
        if (this.controlType == IItemConfigField.EnumControlType.SELECTIONS) {
            for (int i = this.minValue; i <= this.maxValue; ++i) {
                list.put(i, i + this.extension);
            }
        }
        return list;
    }
}

