/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.toolconfig;

import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.itemconfig.IConfigurableItem;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.client.gui.toolconfig.GuiToolConfig;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.network.PacketConfigureTool;
import com.brandon3055.draconicevolution.network.PacketToolProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiConfigureTool
extends GuiScreen
implements GuiPageButtonList.GuiResponder {
    private GuiToolConfig parent;
    private final EntityPlayer player;
    private final ItemStack stack;
    private final PlayerSlot slot;
    private ItemConfigFieldRegistry fieldRegistry = new ItemConfigFieldRegistry();
    public FieldButton[] fieldButtons;
    public int selected = -1;
    public float partialTick;
    public GuiTextField profileField;

    public GuiConfigureTool(GuiToolConfig parent, EntityPlayer player, ItemStack stack, PlayerSlot slot) {
        this.parent = parent;
        this.player = player;
        this.stack = stack;
        this.slot = slot;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.confirmValidation()) {
            return;
        }
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        this.fieldRegistry.clear();
        IConfigurableItem item = (IConfigurableItem)this.stack.func_77973_b();
        item.getFields(this.stack, this.fieldRegistry);
        this.fieldButtons = new FieldButton[this.fieldRegistry.size()];
        int i = 0;
        for (IItemConfigField field : this.fieldRegistry.getFields()) {
            int bHeight = 180 / this.fieldRegistry.size();
            if (bHeight > 20) {
                bHeight = 20;
            }
            int x = -159 + centerX + i % 2 * 180;
            int y = -103 + centerY + i / 2 * bHeight;
            this.fieldButtons[i] = new FieldButton(i, x, y, 138, bHeight - 1, field, this);
            this.field_146292_n.add(this.fieldButtons[i]);
            ++i;
        }
        this.field_146292_n.add(new AdjusterButton(i, centerX - 160, centerY - 6, 320, 18, this));
        this.profileField = new GuiTextField(0, this.field_146289_q, centerX + 50, centerY - 115, 105, 14);
        this.profileField.func_146185_a(false);
        this.profileField.func_146180_a(ToolConfigHelper.getProfileName(this.stack, ToolConfigHelper.getProfile(this.stack)));
        this.profileField.func_146203_f(20);
        this.profileField.func_175207_a((GuiPageButtonList.GuiResponder)this);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.confirmValidation() && this.fieldButtons != null && this.selected >= 0 && this.selected < this.fieldButtons.length) {
            this.fieldButtons[this.selected].field.readFromNBT(ToolConfigHelper.getFieldStorage(this.slot.getStackInSlot(this.player)));
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof AdjusterButton)) continue;
            ((AdjusterButton)button).onUpdate();
        }
    }

    private boolean confirmValidation() {
        if (!this.parent.isItemValid(this.stack) || !this.stack.func_77969_a(this.slot.getStackInSlot(this.player))) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
            return false;
        }
        return true;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        DraconicEvolution.network.sendToServer((IMessage)new PacketToolProfile(this.slot, value));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.partialTick = partialTicks;
        this.func_146276_q_();
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        GuiHelper.drawColouredRect((int)(centerX - 160), (int)(centerY - 120), (int)320, (int)235, (int)-1358954496);
        int border = -16759740;
        GuiHelper.drawColouredRect((int)(centerX - 160), (int)(centerY - 122), (int)320, (int)2, (int)border);
        GuiHelper.drawColouredRect((int)(centerX - 160), (int)(centerY + 115), (int)320, (int)2, (int)border);
        GuiHelper.drawColouredRect((int)(centerX - 162), (int)(centerY - 122), (int)2, (int)239, (int)border);
        GuiHelper.drawColouredRect((int)(centerX + 160), (int)(centerY - 122), (int)2, (int)239, (int)border);
        GuiHelper.drawColouredRect((int)(centerX - 160), (int)(centerY - 8), (int)320, (int)2, (int)border);
        GuiHelper.drawColouredRect((int)(centerX - 160), (int)(centerY + 12), (int)320, (int)2, (int)border);
        GuiHelper.drawColouredRect((int)(centerX - 20), (int)(centerY - 103), (int)40, (int)92, (int)-65536);
        GuiHelper.drawColouredRect((int)(centerX - 19), (int)(centerY - 102), (int)38, (int)90, (int)-16777216);
        this.renderItem(centerX, centerY - 60, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.de.configureItem.txt", (Object[])new Object[0]), centerX, centerY - 116, 65535);
        if (this.selected != -1 && this.fieldButtons != null && this.selected >= 0 && this.selected < this.fieldButtons.length) {
            List lines = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)this.fieldButtons[this.selected].field.getDescription(), (Object[])new Object[0]), 310);
            for (String line : lines) {
                this.field_146289_q.func_78276_b(line, centerX - 159, centerY + 16 + lines.indexOf(line) * 12, 0xFFFFFF);
            }
        }
        GuiHelper.drawColouredRect((int)(centerX + 47), (int)(centerY - 118), (int)108, (int)14, (int)0x50303030);
        this.profileField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (GuiButton button : this.field_146292_n) {
            if (button instanceof FieldButton) {
                ((FieldButton)button).drawToolTips(this.field_146297_k, mouseX, mouseY);
            }
            if (!(button instanceof AdjusterButton)) continue;
            ((AdjusterButton)button).drawToolTips(this.field_146297_k, mouseX, mouseY);
        }
    }

    private void renderItem(int x, int y, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)500.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179152_a((float)24.0f, (float)24.0f, (float)24.0f);
        GlStateManager.func_179114_b((float)(((float)ClientEventHandler.elapsedTicks + partialTicks) * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        this.field_146297_k.func_175599_af().func_181564_a(this.stack, ItemCameraTransforms.TransformType.NONE);
        RenderHelper.func_74518_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof FieldButton) {
            this.selected = button.field_146127_k;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.profileField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.profileField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public class AdjusterButton
    extends GuiButton {
        private final GuiConfigureTool gui;
        private FieldButton activeButton;
        private List<Button> buttonList;
        private boolean dropDownActive;
        private float dropDownPos;
        private boolean isDragging;
        private double dragPos;
        private double releasePos;
        private int dragTick;

        public AdjusterButton(int buttonId, int x, int y, int width, int height, GuiConfigureTool gui) {
            super(buttonId, x, y, width, height, "");
            this.activeButton = null;
            this.buttonList = new ArrayList<Button>();
            this.dropDownActive = false;
            this.dropDownPos = 0.0f;
            this.isDragging = false;
            this.dragPos = 0.0;
            this.releasePos = 0.0;
            this.dragTick = 0;
            this.gui = gui;
        }

        private void initSubButtons() {
            this.buttonList.clear();
            if (this.activeButton != null && this.activeButton.field != null) {
                switch (this.activeButton.field.getType()) {
                    case PLUS3_MINUS3: {
                        this.buttonList.add(new Button(0, this.field_146128_h + 31, this.field_146129_i + 1, 18, 16, "<<<", IItemConfigField.EnumButton.MINUS3));
                        this.buttonList.add(new Button(1, this.field_146128_h + this.field_146120_f - 49, this.field_146129_i + 1, 18, 16, ">>>", IItemConfigField.EnumButton.PLUS3));
                    }
                    case PLUS2_MINUS2: {
                        this.buttonList.add(new Button(2, this.field_146128_h + 50, this.field_146129_i + 1, 14, 16, "<<", IItemConfigField.EnumButton.MINUS2));
                        this.buttonList.add(new Button(3, this.field_146128_h + this.field_146120_f - 64, this.field_146129_i + 1, 14, 16, ">>", IItemConfigField.EnumButton.PLUS2));
                    }
                    case PLUS1_MINUS1: {
                        this.buttonList.add(new Button(4, this.field_146128_h + 65, this.field_146129_i + 1, 10, 16, "<", IItemConfigField.EnumButton.MINUS1));
                        this.buttonList.add(new Button(5, this.field_146128_h + this.field_146120_f - 75, this.field_146129_i + 1, 10, 16, ">", IItemConfigField.EnumButton.PLUS1));
                        this.buttonList.add(new Button(6, this.field_146128_h + 1, this.field_146129_i + 1, 16, 16, "<*", IItemConfigField.EnumButton.MIN));
                        this.buttonList.add(new Button(7, this.field_146128_h + this.field_146120_f - 17, this.field_146129_i + 1, 16, 16, "*>", IItemConfigField.EnumButton.MAX));
                        break;
                    }
                    case SLIDER: {
                        break;
                    }
                    case SELECTIONS: {
                        if (this.dropDownPos != 1.0f) break;
                        Map<Integer, String> values = this.activeButton.field.getValues();
                        int i = 0;
                        for (Integer index : values.keySet()) {
                            int cols = values.size() / 8 + (values.size() % 8 > 0 ? 1 : 0);
                            if (this.field_146120_f - this.field_146120_f / cols * cols >= this.field_146120_f / cols) {
                                ++cols;
                            }
                            int col = i % cols;
                            int xPos = this.field_146128_h + this.field_146120_f / cols * col;
                            int xSize = this.field_146120_f / cols + 1;
                            int yp = 5 + this.field_146129_i + 18 + i / cols * 12;
                            this.buttonList.add(new Button(9 + i, xPos + 1, yp, xSize - 2, 11, values.get(index), IItemConfigField.EnumButton.SELECTION, index));
                            ++i;
                        }
                        break;
                    }
                    case TOGGLE: {
                        this.buttonList.add(new Button(8, this.field_146128_h + this.field_146120_f / 2 - 159, this.field_146129_i + 1, 318, 16, "", IItemConfigField.EnumButton.TOGGLE));
                    }
                }
            }
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float pt) {
            this.updateActiveButton();
            if (this.activeButton == null) {
                return;
            }
            IItemConfigField field = this.activeButton.field;
            switch (this.activeButton.field.getType()) {
                case PLUS3_MINUS3: 
                case PLUS2_MINUS2: 
                case PLUS1_MINUS1: {
                    GuiHelper.drawCenteredString((FontRenderer)mc.field_71466_p, (String)field.getReadableValue(), (int)(this.field_146128_h + this.field_146120_f / 2), (int)(this.field_146129_i + 1), (int)0xFFFFFF, (boolean)false);
                    GuiHelper.drawCenteredString((FontRenderer)mc.field_71466_p, (String)(I18n.func_135052_a((String)"gui.de.min.txt", (Object[])new Object[0]) + ": " + field.getMin() + " - " + I18n.func_135052_a((String)"gui.de.max.txt", (Object[])new Object[0]) + ": " + field.getMax()), (int)(this.field_146128_h + this.field_146120_f / 2), (int)(this.field_146129_i + 10), (int)0xFFFFFF, (boolean)false);
                    break;
                }
                case SLIDER: {
                    double sliderPos = field.getFractionalValue();
                    if (this.isDragging) {
                        sliderPos = ((double)(mouseX - 3) - ((double)this.field_146128_h + 4.0)) / ((double)this.field_146120_f - 14.0);
                        if (sliderPos > 1.0) {
                            sliderPos = 1.0;
                        } else if (sliderPos < 0.0) {
                            sliderPos = 0.0;
                        }
                        this.dragPos = this.releasePos = sliderPos;
                        this.dragTick = 20;
                    }
                    if (this.dragTick > 0) {
                        if (this.dragTick < 10) {
                            double trans = 1.0 - (double)this.dragTick / 10.0;
                            sliderPos = this.dragPos + trans * (sliderPos - this.dragPos);
                        } else {
                            sliderPos = this.dragPos;
                        }
                        --this.dragTick;
                    }
                    int pos = (int)((double)(this.field_146120_f - 14) * sliderPos);
                    boolean mouseOver = GuiHelper.isInRect((int)(this.field_146128_h + 3), (int)(this.field_146129_i + 3), (int)(this.field_146120_f - 6), (int)12, (int)mouseX, (int)mouseY) || this.isDragging;
                    GuiHelper.drawColouredRect((int)(this.field_146128_h + 4), (int)(this.field_146129_i + 8), (int)(this.field_146120_f - 8), (int)2, (int)-14540254);
                    GuiHelper.drawColouredRect((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 2), (int)3, (int)14, (int)-8978432);
                    GuiHelper.drawColouredRect((int)(this.field_146128_h + this.field_146120_f - 4), (int)(this.field_146129_i + 2), (int)3, (int)14, (int)-8978432);
                    GuiHelper.drawColouredRect((int)(this.field_146128_h + 4 + pos), (int)(this.field_146129_i + 3), (int)6, (int)12, (int)(mouseOver ? -16711936 : -65536));
                    GuiHelper.drawColouredRect((int)(this.field_146128_h + 5 + pos), (int)(this.field_146129_i + 4), (int)4, (int)10, (int)-16777216);
                    int txtWidth = mc.field_71466_p.func_78256_a(this.isDragging ? field.getValueFraction(sliderPos) : field.getReadableValue());
                    GuiHelper.drawColouredRect((int)(this.field_146128_h + this.field_146120_f / 2 - txtWidth / 2), (int)this.field_146129_i, (int)txtWidth, (int)8, (int)-2013265920);
                    GuiHelper.drawCenteredString((FontRenderer)mc.field_71466_p, (String)(this.isDragging ? field.getValueFraction(sliderPos) : field.getReadableValue()), (int)(this.field_146128_h + this.field_146120_f / 2), (int)(this.field_146129_i + 1), (int)0xFFFFFF, (boolean)false);
                    break;
                }
                case SELECTIONS: {
                    boolean mouseOver = GuiHelper.isInRect((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 1), (int)(this.field_146120_f - 2), (int)16, (int)mouseX, (int)mouseY);
                    int border = mouseOver ? -16737895 : -14548941;
                    GuiHelper.drawColouredRect((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 1), (int)(this.field_146120_f - 2), (int)16, (int)border);
                    GuiHelper.drawColouredRect((int)(this.field_146128_h + 2), (int)(this.field_146129_i + 2), (int)(this.field_146120_f - 4), (int)14, (int)-16777216);
                    GuiHelper.drawCenteredString((FontRenderer)mc.field_71466_p, (String)field.getReadableValue(), (int)(this.field_146128_h + this.field_146120_f / 2), (int)(this.field_146129_i + 5), (int)0xFFFFFF, (boolean)false);
                    break;
                }
            }
            if (this.dropDownPos > 0.0f) {
                int h = (this.dropDownPos < 1.0f ? (int)((float)this.field_146121_g + GuiConfigureTool.this.partialTick) : this.field_146121_g) - 20;
                GuiHelper.drawColouredRect((int)this.field_146128_h, (int)(this.field_146129_i + 20), (int)this.field_146120_f, (int)h, (int)-16777216);
            }
            for (Button button : this.buttonList) {
                button.drawButton(mc, mouseX, mouseY);
            }
        }

        public void drawToolTips(Minecraft mc, int mouseX, int mouseY) {
            if (this.activeButton == null) {
                return;
            }
            IItemConfigField field = this.activeButton.field;
            switch (this.activeButton.field.getType()) {
                case TOGGLE: {
                    GuiHelper.drawCenteredString((FontRenderer)mc.field_71466_p, (String)field.getReadableValue(), (int)(this.field_146128_h + this.field_146120_f / 2), (int)(this.field_146129_i + 5), (int)0xFFFFFF, (boolean)false);
                }
            }
        }

        private void updateActiveButton() {
            int currentButton;
            int n = currentButton = this.activeButton == null ? -1 : this.activeButton.field_146127_k;
            if (this.gui.selected >= 0 && this.gui.selected < this.gui.fieldButtons.length && this.gui.fieldButtons[this.gui.selected].field != null) {
                this.activeButton = this.gui.fieldButtons[this.gui.selected];
                if (currentButton != this.activeButton.field_146127_k) {
                    this.dropDownActive = false;
                    this.initSubButtons();
                }
            } else {
                this.activeButton = null;
                this.buttonList.clear();
            }
        }

        public void onUpdate() {
            if (this.dropDownActive && this.dropDownPos < 1.0f) {
                this.dropDownPos += 0.2f;
                if (this.dropDownPos > 1.0f) {
                    this.dropDownPos = 1.0f;
                }
                this.field_146121_g = 18 + (int)((double)this.dropDownPos * 103.0);
                this.initSubButtons();
            } else if (!this.dropDownActive && this.dropDownPos > 0.0f) {
                this.dropDownPos -= 0.2f;
                if (this.dropDownPos < 0.0f) {
                    this.dropDownPos = 0.0f;
                }
                this.field_146121_g = 18 + (int)((double)this.dropDownPos * 100.0);
                this.initSubButtons();
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (this.activeButton == null || this.activeButton.field == null) {
                return super.func_146116_c(mc, mouseX, mouseY);
            }
            for (Button button : this.buttonList) {
                if (!button.enabled || !button.buttonPressed(mc, mouseX, mouseY)) continue;
                this.buttonClicked(button);
            }
            switch (this.activeButton.field.getType()) {
                case PLUS3_MINUS3: 
                case PLUS2_MINUS2: 
                case PLUS1_MINUS1: {
                    break;
                }
                case SLIDER: {
                    this.isDragging = GuiHelper.isInRect((int)(this.field_146128_h + 3), (int)(this.field_146129_i + 3), (int)(this.field_146120_f - 6), (int)12, (int)mouseX, (int)mouseY);
                    if (!this.isDragging) break;
                    mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    break;
                }
                case SELECTIONS: {
                    if (!GuiHelper.isInRect((int)this.field_146128_h, (int)this.field_146129_i, (int)this.field_146120_f, (int)18, (int)mouseX, (int)mouseY)) break;
                    this.dropDownActive = !this.dropDownActive;
                    super.func_146113_a(mc.func_147118_V());
                }
            }
            return super.func_146116_c(mc, mouseX, mouseY);
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (this.activeButton == null) {
                return;
            }
            switch (this.activeButton.field.getType()) {
                case PLUS3_MINUS3: 
                case PLUS2_MINUS2: 
                case PLUS1_MINUS1: {
                    break;
                }
                case SLIDER: {
                    break;
                }
            }
        }

        public void func_146118_a(int mouseX, int mouseY) {
            if (this.activeButton != null && this.activeButton.field != null) {
                switch (this.activeButton.field.getType()) {
                    case PLUS3_MINUS3: 
                    case PLUS2_MINUS2: 
                    case PLUS1_MINUS1: {
                        break;
                    }
                    case SLIDER: {
                        if (!this.isDragging) break;
                        double pos = ((double)(mouseX - 3) - ((double)this.field_146128_h + 4.0)) / ((double)this.field_146120_f - 14.0);
                        DraconicEvolution.network.sendToServer((IMessage)new PacketConfigureTool(GuiConfigureTool.this.slot, this.activeButton.field.getName(), IItemConfigField.EnumButton.SLIDER.index, (int)(pos * 10000.0)));
                        GuiConfigureTool.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.9f));
                        break;
                    }
                }
            }
            this.isDragging = false;
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
        }

        private void buttonClicked(Button button) {
            this.updateActiveButton();
            if (this.activeButton == null) {
                return;
            }
            DraconicEvolution.network.sendToServer((IMessage)new PacketConfigureTool(GuiConfigureTool.this.slot, this.activeButton.field.getName(), button.enumButton.index, button.selectionIndex));
            GuiConfigureTool.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }

        public class Button {
            public final int id;
            public final int x;
            public final int y;
            public final int width;
            public final int height;
            public final String text;
            public boolean enabled = true;
            public final IItemConfigField.EnumButton enumButton;
            public int selectionIndex;

            public Button(int id, int x, int y, int width, int height, String text, IItemConfigField.EnumButton enumButton) {
                this.id = id;
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                this.text = text;
                this.enumButton = enumButton;
                this.selectionIndex = 0;
            }

            public Button(int id, int x, int y, int width, int height, String text, IItemConfigField.EnumButton enumButton, int selectionIndex) {
                this(id, x, y, width, height, text, enumButton);
                this.selectionIndex = selectionIndex;
            }

            public void drawButton(Minecraft mc, int mouseX, int mouseY) {
                if (this.enabled) {
                    boolean mouseOver = GuiHelper.isInRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)mouseX, (int)mouseY);
                    int border = mouseOver ? -16736256 : -6291456;
                    GuiHelper.drawColouredRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)border);
                    GuiHelper.drawColouredRect((int)(this.x + 1), (int)(this.y + 1), (int)(this.width - 2), (int)(this.height - 2), (int)-16777216);
                    GuiHelper.drawCenteredString((FontRenderer)mc.field_71466_p, (String)this.text, (int)(this.x + this.width / 2), (int)(this.y + this.height / 2 - mc.field_71466_p.field_78288_b / 2 + 1), (int)0xFFFFFF, (boolean)false);
                }
            }

            public boolean buttonPressed(Minecraft mc, int mouseX, int mouseY) {
                return GuiHelper.isInRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)mouseX, (int)mouseY);
            }
        }
    }

    public class FieldButton
    extends GuiButton {
        public final IItemConfigField field;
        private final GuiConfigureTool gui;

        public FieldButton(int buttonId, int x, int y, int width, int height, IItemConfigField field, GuiConfigureTool gui) {
            super(buttonId, x, y, width, height, "");
            this.field = field;
            this.gui = gui;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float pt) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int back = -16777216;
            GuiHelper.drawColouredRect((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 1), (int)(this.field_146120_f - 2), (int)(this.field_146121_g - 2), (int)back);
            int border = this.field_146123_n || this.gui.selected == this.field_146127_k ? -16737895 : -14548941;
            GuiHelper.drawColouredRect((int)this.field_146128_h, (int)this.field_146129_i, (int)this.field_146120_f, (int)1, (int)border);
            GuiHelper.drawColouredRect((int)this.field_146128_h, (int)(this.field_146129_i + this.field_146121_g - 1), (int)this.field_146120_f, (int)1, (int)border);
            GuiHelper.drawColouredRect((int)this.field_146128_h, (int)this.field_146129_i, (int)1, (int)this.field_146121_g, (int)border);
            GuiHelper.drawColouredRect((int)(this.field_146128_h + this.field_146120_f - 1), (int)this.field_146129_i, (int)1, (int)this.field_146121_g, (int)border);
            GuiHelper.drawCenteredString((FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)this.field.getUnlocalizedName(), (Object[])new Object[0]), (int)(this.field_146128_h + this.field_146120_f / 2), (int)(this.field_146129_i + this.field_146121_g / 2 - mc.field_71466_p.field_78288_b / 2), (int)0xFFFFFF, (boolean)false);
        }

        public void drawToolTips(Minecraft mc, int mouseX, int mouseY) {
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
            if (this.gui.selected != this.field_146127_k) {
                super.func_146113_a(soundHandlerIn);
            }
        }
    }
}

