/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.tubes;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityCableTray;
import cassiokf.industrialrenewal.util.Utils;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public abstract class TileEntityMultiBlocksTube<TE extends TileEntityMultiBlocksTube>
extends TileEntitySync
implements ITickable {
    public final Map<TileEntity, Integer> limitedOutPutMap = new ConcurrentHashMap<TileEntity, Integer>();
    private final Map<TileEntity, EnumFacing> machineContainer = new ConcurrentHashMap<TileEntity, EnumFacing>();
    public int outPut;
    protected boolean inUse = false;
    int outPutCount;
    boolean firstTick = false;
    private TE master;
    private boolean isMaster;
    private boolean startBreaking;

    public void func_73660_a() {
        if (!this.firstTick) {
            this.firstTick = true;
            this.beforeInitialize();
            this.initializeMultiblockIfNecessary();
            this.onFirstTick();
        }
        this.tick();
        this.limitedOutPutMap.clear();
    }

    public void tick() {
    }

    public void beforeInitialize() {
    }

    public void onFirstTick() {
    }

    public void initializeMultiblockIfNecessary() {
        this.initializeMultiblockIfNecessary(false);
    }

    public void initializeMultiblockIfNecessary(boolean forced) {
        if (this.isTray()) {
            return;
        }
        if (forced || this.isMasterInvalid()) {
            if (IRConfig.MainConfig.Main.debugMessages) {
                System.out.println("initialize " + forced + " " + this + " " + this.field_174879_c);
            }
            CopyOnWriteArrayList<TileEntityMultiBlocksTube> connectedCables = new CopyOnWriteArrayList<TileEntityMultiBlocksTube>();
            Stack<TileEntityMultiBlocksTube> traversingCables = new Stack<TileEntityMultiBlocksTube>();
            TileEntityMultiBlocksTube master = this;
            traversingCables.add(this);
            while (!traversingCables.isEmpty()) {
                TileEntityMultiBlocksTube storage = (TileEntityMultiBlocksTube)traversingCables.pop();
                if (storage.isMaster()) {
                    master = storage;
                }
                connectedCables.add(storage);
                for (EnumFacing d : this.getFacesToCheck()) {
                    TileEntity te = this.field_145850_b.func_175625_s(storage.func_174877_v().func_177972_a(d));
                    if (!this.instanceOf(te) || connectedCables.contains(te)) continue;
                    traversingCables.add((TileEntityMultiBlocksTube)te);
                }
            }
            master.getMachineContainers().clear();
            if (this.canBeMaster(master)) {
                for (TileEntityMultiBlocksTube storage : connectedCables) {
                    if (!this.canBeMaster(storage)) continue;
                    storage.setMaster(master);
                    storage.checkForOutPuts();
                    storage.func_70296_d();
                }
            } else {
                for (TileEntityMultiBlocksTube storage : connectedCables) {
                    if (!this.canBeMaster(storage) || this.canBeMaster(master) || !this.canBeMaster(storage)) continue;
                    master = storage;
                    break;
                }
                if (!this.canBeMaster(master)) {
                    return;
                }
                for (TileEntityMultiBlocksTube storage : connectedCables) {
                    if (!this.canBeMaster(storage)) continue;
                    storage.setMaster(master);
                    storage.checkForOutPuts();
                    storage.func_70296_d();
                }
            }
            this.sync();
        }
    }

    public int getLimitedValueForOutPut(int value, int maxTransferAmount, TileEntity storage, boolean simulate) {
        if (!this.limitedOutPutMap.containsKey(storage)) {
            if (!simulate) {
                this.limitedOutPutMap.put(storage, value);
            }
            return Math.min(value, maxTransferAmount);
        }
        int currentValue = this.limitedOutPutMap.get(storage);
        int maxValue = maxTransferAmount - currentValue;
        maxValue = Math.min(value, maxValue);
        if (!simulate) {
            this.limitedOutPutMap.put(storage, currentValue + maxValue);
        }
        return maxValue;
    }

    public boolean isTray() {
        return false;
    }

    private boolean canBeMaster(TileEntity te) {
        return te != null && !(te instanceof TileEntityCableTray);
    }

    public boolean isMasterInvalid() {
        return this.master == null || this.master.func_145837_r();
    }

    public EnumFacing[] getFacesToCheck() {
        return EnumFacing.values();
    }

    public abstract boolean instanceOf(TileEntity var1);

    public abstract void checkForOutPuts();

    public boolean isMaster() {
        return this.isMaster;
    }

    public TE getMaster() {
        if (this.isMaster) {
            return (TE)this;
        }
        this.initializeMultiblockIfNecessary();
        if (this.master != null && !((TileEntityMultiBlocksTube)this.master).isMaster()) {
            this.sync();
        }
        if (this.master == null) {
            if (!this.field_145850_b.field_72995_K && !this.startBreaking) {
                Utils.sendConsoleMessage("MultiBlock Pipe: " + this.getClass().toString() + " has no Master at " + this.field_174879_c);
                Utils.sendConsoleMessage(" Break this pipe and try replace it, If this does not work, report the problem:");
                Utils.sendConsoleMessage("https://github.com/Cassiobsk8/Industrial_Renewal/issues/new?template=bug_report.md");
            }
            return (TE)this;
        }
        return this.master;
    }

    public void setMaster(TE master) {
        boolean wasMaster = this.isMaster;
        this.master = master;
        boolean bl = this.isMaster = master == this;
        if (wasMaster != this.isMaster) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        }
        if (!this.isMaster) {
            this.machineContainer.clear();
        }
    }

    public Map<TileEntity, EnumFacing> getMachineContainers() {
        return this.machineContainer;
    }

    public void addMachine(TileEntity machine, EnumFacing face) {
        if (machine == null) {
            return;
        }
        if (!this.isMaster()) {
            ((TileEntityMultiBlocksTube)this.getMaster()).addMachine(machine, face);
            return;
        }
        this.machineContainer.put(machine, face);
    }

    public void removeMachine(TileEntity machine) {
        if (this.startBreaking || this.func_145837_r() || machine == null) {
            return;
        }
        if (!this.isMaster()) {
            ((TileEntityMultiBlocksTube)this.getMaster()).removeMachine(machine);
            return;
        }
        this.machineContainer.remove(machine);
    }

    public void startBreaking() {
        this.startBreaking = true;
    }

    @Override
    public void onBlockBreak() {
        this.startBreaking = true;
        super.onBlockBreak();
        this.func_145843_s();
        if (IRConfig.MainConfig.Main.debugMessages) {
            System.out.println("Breaking " + this.field_145854_h);
        }
        for (EnumFacing d : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d));
            if (!this.instanceOf(te)) continue;
            if (te instanceof TileEntityCableTray) {
                ((TileEntityCableTray)te).refreshConnections();
                continue;
            }
            ((TileEntityMultiBlocksTube)te).initializeMultiblockIfNecessary(true);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        TileEntityMultiBlocksTube te;
        this.isMaster = compound.func_74767_n("isMaster");
        if (this.func_145830_o() && this.field_145850_b.field_72995_K && (te = (TileEntityMultiBlocksTube)this.field_145850_b.func_175625_s(BlockPos.func_177969_a((long)compound.func_74763_f("masterPos")))) != null) {
            this.master = te;
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("isMaster", this.isMaster);
        if (this.master != null && !this.master.func_145837_r()) {
            compound.func_74772_a("masterPos", this.master.func_174877_v().func_177986_g());
        }
        return super.func_189515_b(compound);
    }
}

