/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.data;

import com.timwoodcreates.roost.RoostConfig;
import com.timwoodcreates.roost.RoostItems;
import com.timwoodcreates.roost.data.DataChicken;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataChickenVanilla
extends DataChicken {
    private static final String VANILLA_TYPE = "minecraft:chicken";

    public static DataChicken getDataFromStack(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74779_i("Chicken").equals(VANILLA_TYPE)) {
            return null;
        }
        return new DataChickenVanilla();
    }

    public static DataChicken getDataFromTooltipNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null || !tagCompound.func_74779_i("Chicken").equals(VANILLA_TYPE)) {
            return null;
        }
        return new DataChickenVanilla();
    }

    public static DataChicken getDataFromEntity(Entity entity) {
        if (entity instanceof EntityChicken) {
            return new DataChickenVanilla();
        }
        return null;
    }

    public static DataChicken getDataFromName(String name) {
        if (name.equals("minecraft:vanilla")) {
            return new DataChickenVanilla();
        }
        return null;
    }

    public static void addAllChickens(List<DataChicken> chickens) {
        chickens.add(new DataChickenVanilla());
    }

    public DataChickenVanilla() {
        super("vanilla", "entity.Chicken.name");
    }

    @Override
    public boolean isEqual(DataChicken other) {
        return other instanceof DataChickenVanilla;
    }

    @Override
    public ItemStack createDropStack() {
        Item item = this.rand.nextInt(3) > 0 && !RoostConfig.disableEggLaying ? Items.field_151110_aK : Items.field_151008_G;
        return new ItemStack(item, 1);
    }

    @Override
    public EntityChicken buildEntity(World world) {
        return new EntityChicken(world);
    }

    @Override
    public void spawnEntity(World world, BlockPos pos) {
        EntityChicken chicken = new EntityChicken(world);
        chicken.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        chicken.func_180482_a(world.func_175649_E(pos), null);
        chicken.func_70873_a(this.getLayTime());
        world.func_72838_d((Entity)chicken);
    }

    @Override
    public ItemStack buildChickenStack() {
        ItemStack stack = new ItemStack((Item)RoostItems.ITEM_CHICKEN);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("Chicken", VANILLA_TYPE);
        stack.func_77982_d(tagCompound);
        return stack;
    }

    @Override
    public NBTTagCompound buildTooltipNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("Chicken", VANILLA_TYPE);
        return tagCompound;
    }

    @Override
    public boolean hasParents() {
        return true;
    }

    @Override
    public List<ItemStack> buildParentChickenStack() {
        return Arrays.asList(this.buildChickenStack(), this.buildChickenStack());
    }

    @Override
    public ItemStack buildCaughtFromStack() {
        ItemStack stack = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)stack, (ResourceLocation)new ResourceLocation("chicken"));
        return stack;
    }

    public String toString() {
        return "DataChickenVanilla [name=" + this.getName() + "]";
    }

    @Override
    public String getChickenType() {
        return "minecraft:vanilla";
    }
}

