/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.proxy;

import com.timwoodcreates.roost.Roost;
import com.timwoodcreates.roost.RoostBlocks;
import com.timwoodcreates.roost.RoostItems;
import com.timwoodcreates.roost.gui.GuiHandler;
import com.timwoodcreates.roost.tileentity.TileEntityBreeder;
import com.timwoodcreates.roost.tileentity.TileEntityCollector;
import com.timwoodcreates.roost.tileentity.TileEntityRoost;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ProxyCommon {
    private static List<Block> blocksToRegister = new LinkedList<Block>();
    private static List<Item> itemsToRegister = new LinkedList<Item>();

    public void preInit(FMLPreInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Roost.INSTANCE, (IGuiHandler)new GuiHandler());
        this.registerBlocks();
        this.registerItems();
        this.registerTileEntities();
        this.registerRecipies();
    }

    public void loadComplete(FMLLoadCompleteEvent e) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : blocksToRegister) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : itemsToRegister) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    private void registerBlocks() {
        this.registerBlock((Block)RoostBlocks.BLOCK_ROOST, "roost");
        this.registerBlock((Block)RoostBlocks.BLOCK_BREEDER, "breeder");
        this.registerBlock((Block)RoostBlocks.BLOCK_COLLECTOR, "collector");
    }

    private void registerItems() {
        this.registerItem(RoostItems.ITEM_CATCHER, "catcher");
        this.registerItem(RoostItems.ITEM_CHICKEN, "chicken");
    }

    private void registerTileEntities() {
        this.registerTileEntity(TileEntityRoost.class, "roost");
        this.registerTileEntity(TileEntityBreeder.class, "breeder");
        this.registerTileEntity(TileEntityCollector.class, "collector");
    }

    private void registerRecipies() {
        GameRegistry.addSmelting((Item)RoostItems.ITEM_CHICKEN, (ItemStack)new ItemStack(Items.field_151077_bg), (float)0.35f);
    }

    private void registerBlock(Block block, String name) {
        block.func_149663_c("roost." + name);
        block.setRegistryName(new ResourceLocation("roost", name));
        block.func_149647_a(Roost.TAB);
        blocksToRegister.add(block);
        ItemBlock item = new ItemBlock(block);
        item.func_77655_b(block.func_149739_a());
        item.setRegistryName(block.getRegistryName());
        itemsToRegister.add((Item)item);
    }

    private void registerItem(Item item, String name) {
        item.func_77655_b("roost." + name);
        item.setRegistryName(new ResourceLocation("roost", name));
        item.func_77637_a(Roost.TAB);
        itemsToRegister.add(item);
    }

    private void registerTileEntity(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (String)("roost:" + name));
    }
}

