/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.render;

import com.google.common.collect.ImmutableList;
import com.timwoodcreates.roost.RoostTextures;
import com.timwoodcreates.roost.block.BlockRoost;
import com.timwoodcreates.roost.data.DataChicken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModelBlockRoost
implements IModel {
    public IModel roostModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("roost:block/roost_box"));
    public IModel chickenModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("roost:block/roost_chicken"));

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        textures.addAll(this.roostModel.getTextures());
        textures.addAll(this.chickenModel.getTextures());
        RoostTextures.stockTextures.stream().map(ModelBlockRoost::getTextureLocation).forEach(textures::add);
        return textures;
    }

    public static Collection<ResourceLocation> getChickenTextures() {
        Set<ResourceLocation> textures = DataChicken.getAllChickens().stream().map(DataChicken::getTextureName).filter(Objects::nonNull).map(ModelBlockRoost::getTextureLocation).collect(Collectors.toSet());
        return textures;
    }

    private static ResourceLocation getTextureLocation(String tex) {
        return new ResourceLocation("roost", "blocks/chicken/" + tex);
    }

    @SubscribeEvent
    public static void preStitch(TextureStitchEvent.Pre event) {
        for (ResourceLocation itemTexture : ModelBlockRoost.getChickenTextures()) {
            event.getMap().func_174942_a(itemTexture);
        }
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModelBlockRoost(state, format, bakedTextureGetter);
    }

    public static class StateMapper
    implements IStateMapper {
        public static StateMapper INSTANCE = new StateMapper();

        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block blockIn) {
            HashMap<IBlockState, ModelResourceLocation> map = new HashMap<IBlockState, ModelResourceLocation>();
            return map;
        }
    }

    public static class ModelBlockRoostLoader
    implements ICustomModelLoader {
        public static ModelBlockRoostLoader INSTANCE = new ModelBlockRoostLoader();

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("roost") && modelLocation.func_110623_a().equals("models/block/roost");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new ModelBlockRoost();
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }

    public class BakedModelBlockRoost
    implements IBakedModel {
        public Map<String, IBakedModel> chickenBakedModels = new HashMap<String, IBakedModel>();
        public IBakedModel roostBakedModel = null;
        ItemOverrideList overrides = new ItemOverrideList((List)ImmutableList.of());
        VertexFormat format;
        IModelState state;
        public final ResourceLocation placeholder = new ResourceLocation("roost", "blocks/chicken/vanilla");

        public BakedModelBlockRoost(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            this.state = state;
            this.format = format;
            this.roostBakedModel = ModelBlockRoost.this.roostModel.bake(state, format, bakedTextureGetter);
            this.chickenBakedModels.put("minecraft:vanilla", ModelBlockRoost.this.chickenModel.bake(state, format, bakedTextureGetter));
        }

        public IBakedModel bakeChicken(String chickenName) {
            DataChicken chickenData = DataChicken.getDataFromName(chickenName);
            ResourceLocation texLoc = ModelBlockRoost.getTextureLocation(chickenData.getTextureName());
            Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            return ModelBlockRoost.this.chickenModel.bake(this.state, this.format, loc -> (TextureAtlasSprite)textureGetter.apply(loc.equals((Object)this.placeholder) ? texLoc : loc));
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            IBakedModel chicken;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            quads.addAll(this.roostBakedModel.func_188616_a(state, side, rand));
            IExtendedBlockState extState = (IExtendedBlockState)state;
            String chickenName = (String)extState.getValue((IUnlistedProperty)BlockRoost.CHICKEN);
            if (!chickenName.equals("roost:empty") && (chicken = this.chickenBakedModels.computeIfAbsent(chickenName, this::bakeChicken)) != null) {
                quads.addAll(chicken.func_188616_a(state, side, rand));
            }
            return quads;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.roostBakedModel.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }
    }
}

