/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.flight;

import java.util.function.Consumer;
import me.paulf.wings.client.apparatus.FlightApparatusView;
import me.paulf.wings.client.apparatus.FlightApparatusViews;
import me.paulf.wings.client.apparatus.WingForm;
import me.paulf.wings.client.flight.Animator;
import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.flight.state.State;
import me.paulf.wings.client.flight.state.StateIdle;
import me.paulf.wings.server.apparatus.FlightApparatuses;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.util.Mth;
import me.paulf.wings.util.SmoothingFunction;
import me.paulf.wings.util.function.FloatConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class FlightViewDefault
implements FlightView {
    private final Flight flight;
    private final WingState absentAnimator = new WingState(Items.field_190931_a, new Strategy(){

        @Override
        public void update(EntityPlayer player) {
        }

        @Override
        public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
        }
    });
    private final SmoothingFunction eyeHeightFunc = SmoothingFunction.create(t -> Mth.easeOutCirc(Mth.easeInOut(t)));
    private WingState animator = this.absentAnimator;

    public FlightViewDefault(Flight flight) {
        this.flight = flight;
    }

    @Override
    public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
        this.animator.ifFormPresent(consumer);
    }

    @Override
    public void tick(EntityPlayer player, ItemStack wings) {
        if (!wings.func_190926_b()) {
            FlightApparatusView view = FlightApparatusViews.get(wings);
            this.animator = view == null ? this.animator.next() : this.animator.next(wings, view);
            this.animator.update(player);
        }
    }

    @Override
    public void tickEyeHeight(float value, float delta, FloatConsumer valueOut) {
        this.eyeHeightFunc.accept(this.flight.getFlyingAmount(delta), SmoothingFunction.Sign.valueOf(this.flight.isFlying()), value, valueOut);
    }

    private final class WingState {
        private final Item item;
        private final Strategy behavior;

        private WingState(Item item, Strategy behavior) {
            this.item = item;
            this.behavior = behavior;
        }

        private WingState next() {
            return FlightViewDefault.this.absentAnimator;
        }

        private WingState next(ItemStack stack, FlightApparatusView view) {
            Item item = stack.func_77973_b();
            if (this.item.equals(item)) {
                return this;
            }
            return this.newState(item, view.getForm());
        }

        private <T extends Animator> WingState newState(Item item, final WingForm<T> shape) {
            return new WingState(item, new Strategy(){
                private final T animator;
                private State state;
                {
                    this.animator = shape.createAnimator();
                    this.state = new StateIdle();
                }

                @Override
                public void update(EntityPlayer player) {
                    this.animator.update();
                    State state = this.state.update(FlightViewDefault.this.flight, player.field_70165_t - player.field_70169_q, player.field_70163_u - player.field_70167_r, player.field_70161_v - player.field_70166_s, player, FlightApparatuses.find(player));
                    if (!this.state.equals(state)) {
                        state.beginAnimation((Animator)this.animator);
                    }
                    this.state = state;
                }

                @Override
                public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
                    consumer.accept(new FlightView.FormRenderer(){

                        @Override
                        public ResourceLocation getTexture() {
                            return shape.getTexture();
                        }

                        @Override
                        public void render(float delta, float scale) {
                            shape.getModel().render(animator, delta, scale);
                        }
                    });
                }
            });
        }

        private void update(EntityPlayer player) {
            this.behavior.update(player);
        }

        private void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
            this.behavior.ifFormPresent(consumer);
        }
    }

    private static interface Strategy {
        public void update(EntityPlayer var1);

        public void ifFormPresent(Consumer<FlightView.FormRenderer> var1);
    }
}

