/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.integration;

import me.paulf.wings.client.renderer.LayerWings;
import me.paulf.wings.server.asm.mobends.GetMoBendsPlayerAnimationEvent;
import me.paulf.wings.server.asm.plugin.Integration;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.util.Mth;
import net.gobbob.mobends.animatedentity.AnimatedEntity;
import net.gobbob.mobends.animation.Animation;
import net.gobbob.mobends.client.event.EventHandlerRenderPlayer;
import net.gobbob.mobends.client.model.ModelRendererBends;
import net.gobbob.mobends.client.model.entity.ModelBendsPlayer;
import net.gobbob.mobends.client.renderer.entity.RenderBendsPlayer;
import net.gobbob.mobends.data.EntityData;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.util.vector.Vector3f;

@Integration(id="mobends_wings", name="Mo' Bending Wings", condition="required-after:wings;after:mobends@[0.24,0.25)")
public final class WingsMoBendsIntegration {
    @SidedProxy(modId="mobends_wings")
    private static Proxy proxy = new Proxy();

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        proxy.preinit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    private static final class AnimationWings
    extends Animation {
        private AnimationWings() {
        }

        public String getName() {
            return "wings";
        }

        public void animate(EntityLivingBase entity, ModelBase model, EntityData data) {
            EntityPlayer player = (EntityPlayer)entity;
            Flight flight = Flights.get(player);
            if (flight != null) {
                AnimationWings.animate((ModelBendsPlayer)model, flight);
            }
        }

        private static void animate(ModelBendsPlayer model, Flight flight) {
            AnimationWings.bends((ModelRenderer)model.field_78115_e).pre_rotation.setSmooth(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f);
            AnimationWings.bends((ModelRenderer)model.field_78115_e).rotation.setSmooth(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f);
            AnimationWings.bends((ModelRenderer)model.field_178723_h).pre_rotation.setSmooth(new Vector3f(0.0f, 0.0f, 0.0f));
            AnimationWings.bends((ModelRenderer)model.field_178724_i).pre_rotation.setSmooth(new Vector3f(0.0f, 0.0f, 0.0f));
            AnimationWings.bends((ModelRenderer)model.bipedRightForeLeg).rotation.setSmoothX(4.0f, 0.1f);
            AnimationWings.bends((ModelRenderer)model.bipedLeftForeLeg).rotation.setSmoothX(4.0f, 0.1f);
            AnimationWings.bends((ModelRenderer)model.bipedRightForeArm).rotation.setSmoothX(-4.0f, 0.1f);
            AnimationWings.bends((ModelRenderer)model.bipedLeftForeArm).rotation.setSmoothX(-4.0f, 0.1f);
            AnimationWings.bends((ModelRenderer)model.field_78116_c).pre_rotation.setSmooth(new Vector3f(0.0f, 0.0f, 0.0f));
            AnimationWings.bends((ModelRenderer)model.field_178722_k).rotation.setSmooth(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f);
            AnimationWings.bends((ModelRenderer)model.field_178721_j).rotation.setSmooth(new Vector3f(0.0f, 0.0f, 0.0f), 0.5f);
            float amt = flight.getFlyingAmount(EventHandlerRenderPlayer.partialTicks);
            AnimationWings.bends((ModelRenderer)model.field_78116_c).rotation.set(Mth.lerp(model.headRotationX, model.headRotationX / 4.0f - 90.0f, amt), model.headRotationY, 0.0f);
            AnimationWings.bends((ModelRenderer)model.field_178724_i).rotation.setSmooth(new Vector3f(Mth.toDegrees(-3.2f) * amt, 0.0f, 0.0f), 1.0f);
            AnimationWings.bends((ModelRenderer)model.field_178723_h).rotation.setSmooth(new Vector3f(Mth.toDegrees(-3.2f) * amt, 0.0f, 0.0f), 1.0f);
            if (!flight.isFlying()) {
                float swing = model.armSwing * 0.6662f;
                float swingAmount = Math.min(1.4f * model.armSwingAmount, 0.15f);
                float var = swing / (float)Math.PI % 2.0f;
                AnimationWings.bends((ModelRenderer)model.field_178721_j).rotation.setSmoothX(-8.0f + 1.1f * Mth.toDegrees(MathHelper.func_76134_b((float)swing) * swingAmount), 0.2f);
                AnimationWings.bends((ModelRenderer)model.field_178722_k).rotation.setSmoothX(-8.0f + 1.1f * Mth.toDegrees(MathHelper.func_76134_b((float)(swing + (float)Math.PI)) * 1.4f * swingAmount), 0.2f);
                AnimationWings.bends((ModelRenderer)model.field_178721_j).rotation.setSmoothZ(12.0f, 0.2f);
                AnimationWings.bends((ModelRenderer)model.field_178722_k).rotation.setSmoothZ(-12.0f, 0.2f);
                AnimationWings.bends((ModelRenderer)model.bipedLeftForeLeg).rotation.setSmoothX(var > 1.0f ? 65.0f : -8.0f, 0.1f);
                AnimationWings.bends((ModelRenderer)model.bipedRightForeLeg).rotation.setSmoothX(var > 1.0f ? -8.0f : 65.0f, 0.1f);
            }
        }

        private static ModelRendererBends bends(ModelRenderer renderer) {
            return (ModelRendererBends)renderer;
        }
    }

    public static final class ClientProxy
    extends Proxy {
        @Override
        void preinit() {
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onGetMoBendsPlayerAnimation(GetMoBendsPlayerAnimationEvent event) {
                    Flight flight = Flights.get(event.getPlayer());
                    if (flight != null && flight.getFlyingAmount(1.0f) > 0.0f) {
                        event.set("wings");
                    }
                }
            });
        }

        @Override
        void init() {
            for (Object obj : AnimatedEntity.skinMap.values()) {
                RenderBendsPlayer renderer = (RenderBendsPlayer)obj;
                renderer.func_177094_a((LayerRenderer)new LayerWings((RenderPlayer)renderer, (player, scale, bodyTransform) -> {
                    bodyTransform.accept(scale);
                    GlStateManager.func_179109_b((float)0.0f, (float)(-12.0f * scale), (float)0.0f);
                }));
            }
            AnimatedEntity ae = AnimatedEntity.get((String)"player");
            ae.add((Animation)new AnimationWings());
        }
    }

    public static final class ServerProxy
    extends Proxy {
    }

    private static class Proxy {
        private Proxy() {
        }

        void preinit() {
        }

        void init() {
        }
    }
}

