/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import me.paulf.wings.util.HandlerSlot;
import me.paulf.wings.util.ItemPlacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public final class ItemAccessor<T extends ICapabilityProvider> {
    private final ImmutableList<ItemPlacing<T>> placings;

    private ItemAccessor(ImmutableList<ItemPlacing<T>> placings) {
        this.placings = placings;
    }

    public Iterable<HandlerSlot> enumerate(T provider) {
        ImmutableList.Builder slots = ImmutableList.builder();
        for (ItemPlacing placing : this.placings) {
            IItemHandler handler = placing.getStorage(provider);
            IntListIterator it = placing.getSlots().iterator();
            while (it.hasNext()) {
                slots.add((Object)HandlerSlot.create(handler, it.nextInt()));
            }
        }
        return slots.build();
    }

    public static <T extends ICapabilityProvider> ItemAccessor<T> none() {
        return new ItemAccessor<T>(ImmutableList.of());
    }

    public static <T extends ICapabilityProvider> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T extends ICapabilityProvider> {
        private final ImmutableList.Builder<ItemPlacing<T>> placings;

        private Builder() {
            this(ImmutableList.builder());
        }

        private Builder(ImmutableList.Builder<ItemPlacing<T>> placings) {
            this.placings = placings;
        }

        public Builder addPlacing(ItemPlacing<T> placing) {
            this.placings.add(placing);
            return this;
        }

        public ItemAccessor<T> build() {
            return new ItemAccessor(this.placings.build());
        }
    }
}

