/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core;

import java.io.File;
import java.io.IOException;
import net.doubledoordev.d3core.client.LanguageHelper;
import net.doubledoordev.d3core.util.CommandSetLoginMessage;
import net.doubledoordev.d3core.util.DevPerks;
import net.doubledoordev.d3core.util.EndermanGriefing;
import net.doubledoordev.d3core.util.EventHandler;
import net.doubledoordev.d3core.util.Materials;
import net.doubledoordev.d3core.util.VoidRefunds;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="d3core", name="D\u00b3Core", updateJSON="http://doubledoordev.net/d3core.json", guiFactory="net.doubledoordev.d3core.client.ModConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class D3Core {
    @Mod.Instance(value="d3core")
    public static D3Core instance;
    @Mod.Metadata
    private ModMetadata metadata;
    private Logger logger;
    private DevPerks devPerks;
    private Configuration configuration;
    private File folder;
    private boolean debug = false;
    private boolean silliness = true;
    private boolean aprilFools = true;
    private boolean pastPost;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.folder = new File(event.getModConfigurationDirectory(), "d3core");
        this.folder.mkdir();
        this.configuration = new Configuration(new File(this.folder, event.getSuggestedConfigurationFile().getName()));
        this.updateConfig();
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            public String getLabel() {
                return "d3core";
            }

            public String call() throws Exception {
                return "Debug: " + D3Core.this.debug + " Silliness: " + D3Core.this.silliness + " AprilFools: " + D3Core.this.aprilFools + " PastPost:" + D3Core.this.pastPost;
            }
        });
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) throws IOException {
        Materials.load();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        EndermanGriefing.init();
        this.pastPost = true;
        if (event.getSide().isClient()) {
            LanguageHelper.run();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSetLoginMessage());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("d3core")) {
            this.updateConfig();
        }
    }

    private void updateConfig() {
        this.configuration.setCategoryLanguageKey("d3core", "d3.core.config.core").setCategoryComment("d3core", "d3.core.config.core");
        this.debug = this.configuration.getBoolean("isDebug", "d3core", this.debug, "Enable isDebug mode", "d3.core.config.isDebug");
        this.silliness = this.configuration.getBoolean("silliness", "d3core", this.silliness, "Enable silliness\nBut seriously, you can disable name changes, drops and block helmets with this setting.", "d3.core.config.silliness");
        EventHandler.norain = this.configuration.getBoolean("norain", "d3core", EventHandler.norain, "No more rain if set to true.", "d3.core.config.norain");
        EventHandler.insomnia = this.configuration.getBoolean("insomnia", "d3core", EventHandler.insomnia, "No more daytime when players sleep if set to true.", "d3.core.config.insomnia");
        EventHandler.lilypad = this.configuration.getBoolean("lilypad", "d3core", EventHandler.lilypad, "Spawn the player on a lilypad when in or above water.", "d3.core.config.lilypad");
        EventHandler.achievementFireworks = this.configuration.getBoolean("achievementFireworks", "d3core", EventHandler.achievementFireworks, "Achievement = Fireworks", "d3.core.config.achievementFireworks");
        EventHandler.nosleep = this.configuration.getBoolean("nosleep", "d3core", EventHandler.nosleep, "No sleep at all", "d3.core.config.nosleep");
        EventHandler.printDeathCoords = this.configuration.getBoolean("printDeathCoords", "d3core", EventHandler.printDeathCoords, "Print your death coordinates in chat (client side)", "d3.core.config.printDeathCoords");
        EventHandler.claysTortureMode = this.configuration.getBoolean("claysTortureMode", "d3core", EventHandler.claysTortureMode, "Deletes all drops on death.", "d3.core.config.claystorturemode");
        D3Core.getDevPerks().update(this.silliness);
        String catTooltips = "d3core.tooltips";
        this.configuration.setCategoryLanguageKey("d3core.tooltips", "d3.core.config.tooltips").addCustomCategoryComment("d3core.tooltips", "d3.core.config.tooltips");
        EventHandler.enableStringID = this.configuration.getBoolean("enableStringID", "d3core.tooltips", true, "Example: minecraft:gold_ore", "d3.core.config.tooltips.enableStringID");
        EventHandler.enableUnlocalizedName = this.configuration.getBoolean("enableUnlocalizedName", "d3core.tooltips", true, "Example: tile.oreGold", "d3.core.config.tooltips.enableUnlocalizedName");
        EventHandler.enableOreDictionary = this.configuration.getBoolean("enableOreDictionary", "d3core.tooltips", true, "Example: oreGold", "d3.core.config.tooltips.enableOreDictionary");
        EventHandler.enableBurnTime = this.configuration.getBoolean("enableBurnTime", "d3core.tooltips", true, "Example: 300 ticks", "d3.core.config.tooltips.enableBurnTime");
        String catEnderGriefing = "d3core.EndermanGriefing";
        this.configuration.setCategoryLanguageKey("d3core.EndermanGriefing", "d3.core.config.EndermanGriefing");
        EndermanGriefing.undo();
        EndermanGriefing.disable = this.configuration.getBoolean("disable", "d3core.EndermanGriefing", false, "Disable Enderman griefing completely.", "d3.core.config.EndermanGriefing.disable");
        EndermanGriefing.dropCarrying = this.configuration.getBoolean("dropCarrying", "d3core.EndermanGriefing", false, "Made Enderman drop there carrying block on death.", "d3.core.config.EndermanGriefing.dropCarrying");
        Property property = this.configuration.get("d3core.EndermanGriefing", "blacklist", new String[0], "List of blocks (minecraft:stone) that will never be allowed to be picked up.");
        property.setLanguageKey("d3.core.config.EndermanGriefing.blacklist");
        EndermanGriefing.blacklist = property.getStringList();
        property = this.configuration.get("d3core.EndermanGriefing", "addlist", new String[0], "List of blocks (minecraft:stone) that will be added to the list of blocks Enderman pick up.");
        property.setLanguageKey("d3.core.config.EndermanGriefing.addlist");
        EndermanGriefing.addList = property.getStringList();
        if (this.pastPost) {
            EndermanGriefing.init();
        }
        VoidRefunds.config(this.configuration);
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    public static Logger getLogger() {
        return D3Core.instance.logger;
    }

    public static boolean isDebug() {
        return D3Core.instance.debug;
    }

    public static Configuration getConfig() {
        return D3Core.instance.configuration;
    }

    private static DevPerks getDevPerks() {
        if (D3Core.instance.devPerks == null) {
            D3Core.instance.devPerks = new DevPerks();
        }
        return D3Core.instance.devPerks;
    }

    public static File getFolder() {
        return D3Core.instance.folder;
    }
}

