/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.client;

import java.util.LinkedHashMap;
import java.util.Map;
import net.doubledoordev.d3core.events.D3LanguageInjectEvent;
import net.doubledoordev.d3core.util.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="d3core", value={Side.CLIENT})
public final class LanguageHelper {
    private static final LinkedHashMap<String, Integer> ROMAN_NUMERALS = new LinkedHashMap();
    private static final String PREFIX = "enchantment.level.";

    private LanguageHelper() {
    }

    public static void run() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                D3LanguageInjectEvent event = new D3LanguageInjectEvent();
                MinecraftForge.EVENT_BUS.post((Event)event);
                LanguageMap.func_135063_a(event.map);
            }
        });
    }

    private static String romanNumerals(int Int) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : ROMAN_NUMERALS.entrySet()) {
            int matches = Int / entry.getValue();
            String s = entry.getKey();
            for (int i = 0; i < matches; ++i) {
                builder.append(s);
            }
            Int %= entry.getValue().intValue();
        }
        return builder.toString();
    }

    @SubscribeEvent
    public static void d3LanguageInjectEvent(D3LanguageInjectEvent event) {
        Enchantment enchantment = null;
        int i = 0;
        while (enchantment == null) {
            enchantment = (Enchantment)Enchantment.field_185264_b.func_148754_a(i++);
        }
        Item item = null;
        int i2 = 0;
        while (item == null) {
            item = (Item)Item.field_150901_e.func_148754_a(i2++);
        }
        ItemStack s = new ItemStack(item);
        s.func_77966_a(enchantment, Integer.MAX_VALUE);
        int max = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)s);
        for (int i3 = 0; i3 < max; ++i3) {
            String key = PREFIX + i3;
            if (event.map.containsKey(key)) continue;
            String val = LanguageHelper.romanNumerals(i3);
            event.map.put(key, val);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void itemTooltipEventHandler(ItemTooltipEvent event) {
        if (event.getFlags().func_194127_a() && !event.getItemStack().func_190926_b()) {
            if (EventHandler.enableStringID) {
                event.getToolTip().add(TextFormatting.DARK_AQUA + event.getItemStack().func_77973_b().getRegistryName().toString());
            }
            if (EventHandler.enableUnlocalizedName) {
                event.getToolTip().add(TextFormatting.DARK_GREEN + event.getItemStack().func_77977_a());
            }
            if (EventHandler.enableOreDictionary) {
                for (int id : OreDictionary.getOreIDs((ItemStack)event.getItemStack())) {
                    event.getToolTip().add(TextFormatting.DARK_PURPLE + OreDictionary.getOreName((int)id));
                }
            }
            if (EventHandler.enableBurnTime && TileEntityFurnace.func_145954_b((ItemStack)event.getItemStack())) {
                event.getToolTip().add(TextFormatting.GOLD + "Burns for " + TileEntityFurnace.func_145952_a((ItemStack)event.getItemStack()) + " ticks");
            }
        }
    }

    static {
        ROMAN_NUMERALS.put("M", 1000);
        ROMAN_NUMERALS.put("CM", 900);
        ROMAN_NUMERALS.put("D", 500);
        ROMAN_NUMERALS.put("CD", 400);
        ROMAN_NUMERALS.put("C", 100);
        ROMAN_NUMERALS.put("XC", 90);
        ROMAN_NUMERALS.put("L", 50);
        ROMAN_NUMERALS.put("XL", 40);
        ROMAN_NUMERALS.put("X", 10);
        ROMAN_NUMERALS.put("IX", 9);
        ROMAN_NUMERALS.put("V", 5);
        ROMAN_NUMERALS.put("IV", 4);
        ROMAN_NUMERALS.put("I", 1);
    }
}

