/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.doubledoordev.d3core.D3Core;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;

public final class EndermanGriefing {
    public static boolean disable;
    public static boolean dropCarrying;
    public static String[] blacklist;
    public static String[] addList;
    private static HashMap<String, Boolean> reverseMap;

    private EndermanGriefing() {
    }

    public static void init() {
        if (disable) {
            RegistryNamespacedDefaultedByKey blockData = Block.field_149771_c;
            for (ResourceLocation key : blockData.func_148742_b()) {
                Block block = (Block)blockData.func_82594_a((Object)key);
                reverseMap.put(((ResourceLocation)blockData.func_177774_c((Object)block)).toString(), EntityEnderman.getCarriable((Block)block));
                EntityEnderman.setCarriable((Block)block, (boolean)false);
            }
        } else {
            Set<Block> blocks;
            int added = 0;
            int removed = 0;
            for (String item : addList) {
                blocks = EndermanGriefing.matchBlock(item);
                if (blocks.isEmpty()) {
                    D3Core.getLogger().warn("[EndermanGriefing] '{}' does not match any block...", (Object)item);
                    continue;
                }
                for (Block block : blocks) {
                    reverseMap.put(item, EntityEnderman.getCarriable((Block)block));
                    EntityEnderman.setCarriable((Block)block, (boolean)true);
                    ++added;
                }
            }
            for (String item : blacklist) {
                blocks = EndermanGriefing.matchBlock(item);
                if (blocks.isEmpty()) {
                    D3Core.getLogger().warn("[EndermanGriefing] '{}' does not match any block...", (Object)item);
                    continue;
                }
                for (Block block : blocks) {
                    reverseMap.put(item, EntityEnderman.getCarriable((Block)block));
                    EntityEnderman.setCarriable((Block)block, (boolean)false);
                    ++removed;
                }
            }
            D3Core.getLogger().info("[EndermanGriefing] Added {} and removed {} blocks to the Enderman grab list...", (Object)added, (Object)removed);
        }
    }

    private static Set<Block> matchBlock(String item) {
        HashSet<Block> blocks = new HashSet<Block>();
        Pattern pattern = Pattern.compile(item.replace("*", ".*?"));
        RegistryNamespacedDefaultedByKey blockData = Block.field_149771_c;
        for (Block block : blockData) {
            if (!pattern.matcher(((ResourceLocation)blockData.func_177774_c((Object)block)).toString()).matches()) continue;
            blocks.add(block);
        }
        return blocks;
    }

    public static void undo() {
        for (String entry : reverseMap.keySet()) {
            EntityEnderman.setCarriable((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(entry))), (boolean)reverseMap.get(entry));
        }
    }

    static {
        reverseMap = new HashMap();
    }
}

