/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import net.doubledoordev.d3core.D3Core;
import net.doubledoordev.d3core.util.CoreConstants;
import net.doubledoordev.d3core.util.EndermanGriefing;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.FileUtils;

@Mod.EventBusSubscriber(modid="d3core")
public final class EventHandler {
    public static boolean enableStringID;
    public static boolean enableUnlocalizedName;
    public static boolean enableOreDictionary;
    public static boolean enableBurnTime;
    public static boolean nosleep;
    public static boolean printDeathCoords;
    public static boolean claysTortureMode;
    public static boolean norain;
    public static boolean insomnia;
    public static boolean lilypad;
    public static boolean achievementFireworks;

    private EventHandler() {
    }

    @SubscribeEvent
    public static void achievementEvent(AdvancementEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (achievementFireworks && FMLCommonHandler.instance().getEffectiveSide().isServer() && player.func_184102_h() != null) {
            CoreConstants.spawnRandomFireworks((Entity)player, 1, 1);
        }
    }

    @SubscribeEvent
    public static void entityDeathEvent(LivingDropsEvent event) {
        EntityEnderman entityEnderman;
        IBlockState state;
        if (event.getEntityLiving() instanceof EntityPlayer && claysTortureMode) {
            event.setCanceled(true);
        } else if (event.getEntityLiving() instanceof EntityEnderman && EndermanGriefing.dropCarrying && (state = (entityEnderman = (EntityEnderman)event.getEntityLiving()).func_175489_ck()) != null && state.func_177230_c() != Blocks.field_150350_a) {
            ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            event.getDrops().add(new EntityItem(entityEnderman.field_70170_p, entityEnderman.field_70165_t, entityEnderman.field_70163_u, entityEnderman.field_70161_v, stack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && printDeathCoords) {
            TextComponentString posText = new TextComponentString("X: " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70165_t) + " Y: " + MathHelper.func_76128_c((double)(event.getEntityLiving().field_70163_u + 0.5)) + " Z: " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70161_v));
            try {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server.func_71187_D().func_71557_a((ICommandSender)event.getEntityLiving()).contains(server.func_71187_D().func_71555_a().get("tp"))) {
                    posText.func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to teleport!"))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70165_t) + " " + MathHelper.func_76128_c((double)(event.getEntityLiving().field_70163_u + 0.5)) + " " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70161_v))));
                }
                if (server.func_71187_D().func_71557_a((ICommandSender)event.getEntityLiving()).contains(server.func_71187_D().func_71555_a().get("tpx"))) {
                    posText.func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to teleport!"))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpx " + ((EntityPlayer)event.getEntityLiving()).field_71093_bK + " " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70165_t) + " " + MathHelper.func_76128_c((double)(event.getEntityLiving().field_70163_u + 0.5)) + " " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70161_v))));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            event.getEntityLiving().func_145747_a(new TextComponentString("You died at ").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150257_a((ITextComponent)posText));
        }
    }

    @SubscribeEvent
    public static void sleepEvent(PlayerSleepInBedEvent event) {
        if (nosleep) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public static void worldTickHandler(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (norain) {
            WorldInfo worldInfo = event.world.func_72912_H();
            worldInfo.func_76069_a(false);
            worldInfo.func_76084_b(false);
            worldInfo.func_76080_g(Integer.MAX_VALUE);
            worldInfo.func_76090_f(Integer.MAX_VALUE);
        }
    }

    @SubscribeEvent
    public static void playerTickHandler(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (insomnia && event.player.field_71076_b > 90) {
            event.player.field_71076_b = 90;
        }
    }

    @SubscribeEvent
    public static void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        File file = new File(D3Core.getFolder(), "loginmessage.txt");
        if (file.exists()) {
            try {
                String txt = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
                try {
                    event.player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)txt));
                }
                catch (JsonParseException jsonparseexception) {
                    event.player.func_145747_a((ITextComponent)new TextComponentString(txt));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (lilypad) {
            EventHandler.lilypad(event.player);
        }
    }

    @SubscribeEvent
    public static void playerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (lilypad) {
            EventHandler.lilypad(event.player);
        }
    }

    private static void lilypad(EntityPlayer player) {
        World world = player.field_70170_p;
        BlockPos blockPos = new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        if (blockPos.func_177958_n() < 0) {
            blockPos = blockPos.func_177982_a(-1, 0, 0);
        }
        if (blockPos.func_177952_p() < 0) {
            blockPos = blockPos.func_177982_a(0, 0, -1);
        }
        int limiter = world.func_72940_L() * 2;
        while (world.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h && --limiter != 0) {
            blockPos = blockPos.func_177982_a(0, 1, 0);
        }
        while (world.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a && --limiter != 0) {
            blockPos = blockPos.func_177982_a(0, -1, 0);
        }
        if (limiter == 0) {
            return;
        }
        if (world.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h) {
            world.func_175656_a(blockPos.func_177982_a(0, 1, 0), Blocks.field_150392_bi.func_176223_P());
            player.func_70634_a((double)blockPos.func_177958_n() + 0.5, (double)(blockPos.func_177956_o() + 2), (double)blockPos.func_177952_p() + 0.5);
        }
    }

    static {
        printDeathCoords = true;
    }
}

