/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import net.doubledoordev.d3core.D3Core;
import net.doubledoordev.d3core.util.CoreConstants;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class Materials {
    public static void load() throws IOException {
        Object e;
        File file = new File(D3Core.getFolder(), "materials.json");
        if (!file.exists()) {
            return;
        }
        Map stringMap = (Map)CoreConstants.GSON.fromJson(FileUtils.readFileToString((File)file, (String)"utf-8"), Map.class);
        HashMap<String, ItemStack> itemStackMap = new HashMap<String, ItemStack>(stringMap.size());
        boolean stop = false;
        for (Map.Entry entry : stringMap.entrySet()) {
            Item item;
            Matcher matcher = CoreConstants.PATTERN_ITEMSTACK.matcher((CharSequence)entry.getValue());
            if (!matcher.matches()) {
                D3Core.getLogger().error("Entry in materials.json does not match a valid ItemStack text: {}.", entry);
                stop = true;
                continue;
            }
            String mod = matcher.group("mod");
            String name = matcher.group("name");
            String metaString = matcher.group("meta");
            String stacksizeString = matcher.group("stacksize");
            if (Strings.isNullOrEmpty((String)mod)) {
                mod = "minecraft";
            }
            if (!Loader.isModLoaded((String)mod)) {
                D3Core.getLogger().warn("Skipped materials.json entry {} because mod {} is not loaded.", entry, (Object)mod);
                continue;
            }
            int meta = Short.MAX_VALUE;
            int stacksize = 1;
            if (!Strings.isNullOrEmpty((String)metaString) && !metaString.equals("*")) {
                meta = Integer.parseInt(metaString);
            }
            if (!Strings.isNullOrEmpty((String)stacksizeString)) {
                stacksize = Integer.parseInt(stacksizeString);
            }
            if ((item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, name))) == null) {
                D3Core.getLogger().error("Entry in materials.json {} invalid. Item {}:{} does not exist.", entry, (Object)mod, (Object)name);
                stop = true;
                continue;
            }
            ItemStack stack = new ItemStack(item, stacksize, meta);
            if (stack.func_190926_b()) {
                D3Core.getLogger().error("Entry in materials.json {} invalid. Item {}:{} does not exist.", entry, (Object)mod, (Object)name);
                stop = true;
                continue;
            }
            itemStackMap.put(((String)entry.getKey()).toLowerCase(), stack);
        }
        if (stop) {
            D3Core.getLogger().fatal("The proper format for materials.json entries is (in regex): {}", (Object)CoreConstants.PATTERN_ITEMSTACK.pattern());
            e = new RuntimeException("You have invalid entries in your materials.json file. Check the log for more info.");
            ((Throwable)e).setStackTrace(new StackTraceElement[0]);
            throw e;
        }
        for (Item.ToolMaterial material : Item.ToolMaterial.values()) {
            ItemStack stack = (ItemStack)itemStackMap.get(material.name().toLowerCase());
            if (stack == null) continue;
            if (!material.getRepairItemStack().func_190926_b()) {
                D3Core.getLogger().fatal("Material {} already has {} as repair material. You cannot override it.", (Object)material.name(), (Object)material.getRepairItemStack());
                stop = true;
                continue;
            }
            material.setRepairItem(stack);
        }
        if (stop) {
            D3Core.getLogger().fatal("You tried to set the repair stack of a ToolMaterial that already has one. This is not allowed by Forge.");
            e = new RuntimeException("You tried to set the repair stack of a ToolMaterial that already has one. This is not allowed by Forge. Check the log for more info.");
            ((Throwable)e).setStackTrace(new StackTraceElement[0]);
            throw e;
        }
    }
}

