/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="d3core")
public final class VoidRefunds {
    private static int[] voidRefundDimensions;
    private static final HashMap<UUID, InventoryPlayer> map;

    private VoidRefunds() {
    }

    public static void config(Configuration configuration) {
        String catVoidDeaths = "d3core.VoidDeaths";
        configuration.addCustomCategoryComment("d3core.VoidDeaths", "In these dimensions, when you die to void damage, you will keep your items.");
        voidRefundDimensions = configuration.get("d3core.VoidDeaths", "refundDimensions", new int[0]).getIntList();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void livingDeathEvent(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (event.getSource() != DamageSource.field_76380_i || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntityLiving().field_110153_bc >= 1.7014117E38f) {
            return;
        }
        for (int dim : voidRefundDimensions) {
            if (dim != event.getEntity().field_71093_bK) continue;
            event.setCanceled(true);
            InventoryPlayer tempCopy = new InventoryPlayer(null);
            tempCopy.func_70455_b(((EntityPlayer)event.getEntity()).field_71071_by);
            map.put(event.getEntity().getPersistentID(), tempCopy);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        InventoryPlayer oldInventory = map.get(event.player.getPersistentID());
        if (oldInventory == null) {
            return;
        }
        event.player.field_71071_by.func_70455_b(oldInventory);
        map.remove(event.player.getPersistentID());
    }

    static {
        map = new HashMap();
    }
}

