/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.math;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import xyz.przemyk.simpleplanes.math.Quaternion;
import xyz.przemyk.simpleplanes.math.Vector3f;

public class MathUtil
extends MathHelper {
    public static void hamiltonProduct(Quaternion this_, Quaternion other) {
        float f = this_.getX();
        float g = this_.getY();
        float h = this_.getZ();
        float i = this_.getW();
        float j = other.getX();
        float k = other.getY();
        float l = other.getZ();
        float m = other.getW();
        this_.x = i * j + f * m + g * l - h * k;
        this_.y = i * k - f * l + g * m + h * j;
        this_.z = i * l + f * k - g * j + h * m;
        this_.w = i * m - f * j - g * k - h * l;
    }

    public static Quaternion rotationDegreesX(float rotationAngle) {
        float f = MathUtil.func_76126_a((float)((rotationAngle *= (float)Math.PI / 180) / 2.0f));
        float w = MathUtil.func_76134_b((float)(rotationAngle / 2.0f));
        return new Quaternion(f, 0.0f, 0.0f, w);
    }

    public static Quaternion rotationDegreesY(float rotationAngle) {
        float f = MathUtil.func_76126_a((float)((rotationAngle *= (float)Math.PI / 180) / 2.0f));
        float w = MathUtil.func_76134_b((float)(rotationAngle / 2.0f));
        return new Quaternion(0.0f, f, 0.0f, w);
    }

    public static Quaternion rotationDegreesZ(float rotationAngle) {
        float f = MathUtil.func_76126_a((float)((rotationAngle *= (float)Math.PI / 180) / 2.0f));
        float w = MathUtil.func_76134_b((float)(rotationAngle / 2.0f));
        return new Quaternion(0.0f, 0.0f, f, w);
    }

    public static double angelBetweenVec(Vec3d v1, Vec3d v2) {
        return Math.toDegrees(Math.acos(MathUtil.normalizedDotProduct(v1, v2)));
    }

    public static double normalizedDotProduct(Vec3d v1, Vec3d v2) {
        return v1.func_72430_b(v2) / (v1.func_72433_c() * v2.func_72433_c());
    }

    public static float getPitch(Vec3d motion) {
        double y = motion.field_72448_b;
        return (float)Math.toDegrees(Math.atan2(y, Math.sqrt(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c)));
    }

    public static float getYaw(Vec3d motion) {
        return (float)Math.toDegrees(Math.atan2(-motion.field_72450_a, motion.field_72449_c));
    }

    public static float lerpAngle(float perc, float start, float end) {
        return start + perc * MathUtil.func_76142_g((float)(end - start));
    }

    public static float lerpAngle180(float perc, float start, float end) {
        if (MathUtil.degreesDifferenceAbs(start, end) > 90.0) {
            end += 180.0f;
        }
        return start + perc * MathUtil.func_76142_g((float)(end - start));
    }

    public static double lerpAngle180(double perc, double start, double end) {
        if (MathUtil.degreesDifferenceAbs(start, end) > 90.0) {
            end += 180.0;
        }
        return start + perc * MathUtil.func_76138_g((double)(end - start));
    }

    public static double lerpAngle(double perc, double start, double end) {
        return start + perc * MathUtil.func_76138_g((double)(end - start));
    }

    public static double degreesDifferenceAbs(double p_203301_0_, double p_203301_1_) {
        return Math.abs(MathUtil.wrapSubtractDegrees(p_203301_0_, p_203301_1_));
    }

    public static double wrapSubtractDegrees(double p_203302_0_, double p_203302_1_) {
        return MathUtil.func_76138_g((double)(p_203302_1_ - p_203302_0_));
    }

    public static Vec3d rotationToVector(double yaw, double pitch) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        double xzLen = Math.cos(pitch);
        double x = -xzLen * Math.sin(yaw);
        double y = Math.sin(pitch);
        double z = xzLen * Math.cos(-yaw);
        return new Vec3d(x, y, z);
    }

    public static Vec3d rotationToVector(double yaw, double pitch, double size) {
        Vec3d vec = MathUtil.rotationToVector(yaw, pitch);
        return vec.func_186678_a(size / vec.func_72433_c());
    }

    public static double getHorizontalLength(Vec3d Vec3d2) {
        return Math.sqrt(Vec3d2.field_72450_a * Vec3d2.field_72450_a + Vec3d2.field_72449_c * Vec3d2.field_72449_c);
    }

    public static EulerAngles toEulerAngles(Quaternion q) {
        EulerAngles angles = new EulerAngles();
        double sinr_cosp = 2.0f * (q.getW() * q.getZ() + q.getX() * q.getY());
        double cosr_cosp = 1.0f - 2.0f * (q.getZ() * q.getZ() + q.getX() * q.getX());
        angles.roll = Math.toDegrees(Math.atan2(sinr_cosp, cosr_cosp));
        double sinp = 2.0f * (q.getW() * q.getX() - q.getY() * q.getZ());
        angles.pitch = Math.abs(sinp) >= 0.98 ? -Math.toDegrees(Math.signum(sinp) * Math.PI / 2.0) : -Math.toDegrees(Math.asin(sinp));
        double siny_cosp = 2.0f * (q.getW() * q.getY() + q.getZ() * q.getX());
        double cosy_cosp = 1.0f - 2.0f * (q.getX() * q.getX() + q.getY() * q.getY());
        angles.yaw = Math.toDegrees(Math.atan2(siny_cosp, cosy_cosp));
        return angles;
    }

    public static float fastInvSqrt(float number) {
        float f = 0.5f * number;
        int i = Float.floatToIntBits(number);
        i = 1597463007 - (i >> 1);
        number = Float.intBitsToFloat(i);
        return number * (1.5f - f * number * number);
    }

    public static Quaternion normalizeQuaternion(Quaternion q) {
        float f = q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW();
        float x = q.getX();
        float y = q.getY();
        float z = q.getZ();
        float w = q.getW();
        if (f > 1.0E-6f) {
            float f1 = MathUtil.fastInvSqrt(f);
            return new Quaternion(x *= f1, y *= f1, z *= f1, w *= f1);
        }
        return new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Quaternion toQuaternion(double yaw, double pitch, double roll) {
        yaw = Math.toRadians(yaw);
        pitch = -Math.toRadians(pitch);
        roll = Math.toRadians(roll);
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        float w = (float)(cr * cp * cy + sr * sp * sy);
        float z = (float)(sr * cp * cy - cr * sp * sy);
        float x = (float)(cr * sp * cy + sr * cp * sy);
        float y = (float)(cr * cp * sy - sr * sp * cy);
        return new Quaternion(x, y, z, w);
    }

    public static Quaternion lerpQ(float perc, Quaternion start, Quaternion end) {
        double DOT_THRESHOLD;
        start = MathUtil.normalizeQuaternion(start);
        end = MathUtil.normalizeQuaternion(end);
        double dot = start.getX() * end.getX() + start.getY() * end.getY() + start.getZ() * end.getZ() + start.getW() * end.getW();
        if (dot < 0.0) {
            end = new Quaternion(-end.getX(), -end.getY(), -end.getZ(), -end.getW());
            dot = -dot;
        }
        if (dot > (DOT_THRESHOLD = 0.9995)) {
            Quaternion quaternion = new Quaternion(start.getX() * (1.0f - perc) + end.getX() * perc, start.getY() * (1.0f - perc) + end.getY() * perc, start.getZ() * (1.0f - perc) + end.getZ() * perc, start.getW() * (1.0f - perc) + end.getW() * perc);
            return MathUtil.normalizeQuaternion(quaternion);
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)perc;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        float s0 = (float)(Math.cos(theta) - dot * sin_theta / sin_theta_0);
        float s1 = (float)(sin_theta / sin_theta_0);
        Quaternion quaternion = new Quaternion(start.getX() * s0 + end.getX() * s1, start.getY() * s0 + end.getY() * s1, start.getZ() * s0 + end.getZ() * s1, start.getW() * s0 + end.getW() * s1);
        return MathUtil.normalizeQuaternion(quaternion);
    }

    public static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static void transformVec(Vector3f vec, Quaternion rotation) {
        Quaternion quaternion = new Quaternion(rotation);
        MathUtil.hamiltonProduct(quaternion, new Quaternion(vec.getX(), vec.getY(), vec.getZ(), 0.0f));
        Quaternion quaternion2 = new Quaternion(rotation);
        quaternion2.negate();
        MathUtil.hamiltonProduct(quaternion, quaternion2);
        vec.set(quaternion.getX(), quaternion.getY(), quaternion.getZ());
    }

    public static class EulerAngles {
        public double pitch;
        public double yaw;
        public double roll;

        public EulerAngles() {
        }

        public EulerAngles(double pitch, double yaw, double roll) {
            this.pitch = pitch;
            this.yaw = yaw;
            this.roll = roll;
        }

        public EulerAngles(EulerAngles a) {
            this.pitch = a.pitch;
            this.yaw = a.yaw;
            this.roll = a.roll;
        }

        public EulerAngles copy() {
            return new EulerAngles(this);
        }

        public String toString() {
            return "EulerAngles{pitch=" + this.pitch + ", yaw=" + this.yaw + ", roll=" + this.roll + '}';
        }
    }
}

