/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.transport.pipe.IFlowFluid;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEvent;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public abstract class PipeEventFluid
extends PipeEvent {
    public final IFlowFluid flow;

    protected PipeEventFluid(IPipeHolder holder, IFlowFluid flow) {
        super(holder);
        this.flow = flow;
    }

    @Deprecated
    protected PipeEventFluid(boolean canBeCancelled, IPipeHolder holder, IFlowFluid flow) {
        super(canBeCancelled, holder);
        this.flow = flow;
    }

    public static class SideCheck
    extends PipeEventFluid {
        public final FluidStack fluid;
        private final int[] priority = new int[6];
        private final EnumSet<EnumFacing> allowed = EnumSet.allOf(EnumFacing.class);

        public SideCheck(IPipeHolder holder, IFlowFluid flow, FluidStack fluid) {
            super(holder, flow);
            this.fluid = fluid;
        }

        public boolean isAllowed(EnumFacing side) {
            return this.allowed.contains(side);
        }

        public void disallow(EnumFacing ... sides) {
            for (EnumFacing side : sides) {
                this.allowed.remove(side);
            }
        }

        public void disallowAll(Collection<EnumFacing> sides) {
            this.allowed.removeAll(sides);
        }

        public void disallowAllExcept(EnumFacing ... sides) {
            this.allowed.retainAll(Lists.newArrayList((Object[])sides));
        }

        public void disallowAllExcept(Collection<EnumFacing> sides) {
            this.allowed.retainAll(sides);
        }

        public void disallowAll() {
            this.allowed.clear();
        }

        public void increasePriority(EnumFacing side) {
            this.increasePriority(side, 1);
        }

        public void increasePriority(EnumFacing side, int by) {
            int n = side.ordinal();
            this.priority[n] = this.priority[n] - by;
        }

        public void decreasePriority(EnumFacing side) {
            this.decreasePriority(side, 1);
        }

        public void decreasePriority(EnumFacing side, int by) {
            this.increasePriority(side, -by);
        }

        public EnumSet<EnumFacing> getOrder() {
            block6: {
                if (this.allowed.isEmpty()) {
                    return EnumSet.noneOf(EnumFacing.class);
                }
                if (this.allowed.size() == 1) {
                    return this.allowed;
                }
                int val = this.priority[0];
                for (int i = 1; i < this.priority.length; ++i) {
                    if (this.priority[i] == val) {
                        continue;
                    }
                    break block6;
                }
                return this.allowed;
            }
            int[] ordered = Arrays.copyOf(this.priority, 6);
            Arrays.sort(ordered);
            int last = 0;
            for (int i = 0; i < 6; ++i) {
                int current = ordered[i];
                if (i != 0 && current == last) continue;
                last = current;
                EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    if (!this.allowed.contains(face) || this.priority[face.ordinal()] != current) continue;
                    set.add(face);
                }
                if (set.size() <= 0) continue;
                return set;
            }
            return EnumSet.noneOf(EnumFacing.class);
        }
    }

    public static class OnMoveToCentre
    extends PipeEventFluid {
        public final FluidStack fluid;
        public final int[] fluidLeavingSide;
        public final int[] fluidEnteringCentre;
        private final int[] fluidLeaveCheck;
        private final int[] fluidEnterCheck;

        public OnMoveToCentre(IPipeHolder holder, IFlowFluid flow, FluidStack fluid, int[] fluidLeavingSide, int[] fluidEnteringCentre) {
            super(holder, flow);
            this.fluid = fluid;
            this.fluidLeavingSide = fluidLeavingSide;
            this.fluidEnteringCentre = fluidEnteringCentre;
            this.fluidLeaveCheck = Arrays.copyOf(fluidLeavingSide, fluidLeavingSide.length);
            this.fluidEnterCheck = Arrays.copyOf(fluidEnteringCentre, fluidEnteringCentre.length);
        }

        @Override
        public String checkStateForErrors() {
            for (int i = 0; i < this.fluidLeavingSide.length; ++i) {
                if (this.fluidLeavingSide[i] > this.fluidLeaveCheck[i]) {
                    return "fluidLeavingSide[" + i + "](=" + this.fluidLeavingSide[i] + ") shouldn't be bigger than its original value!(=" + this.fluidLeaveCheck[i] + ")";
                }
                if (this.fluidEnteringCentre[i] > this.fluidEnterCheck[i]) {
                    return "fluidEnteringCentre[" + i + "](=" + this.fluidEnteringCentre[i] + ") shouldn't be bigger than its original value!(=" + this.fluidEnterCheck[i] + ")";
                }
                if (this.fluidEnteringCentre[i] <= this.fluidLeavingSide[i]) continue;
                return "fluidEnteringCentre[" + i + "](=" + this.fluidEnteringCentre[i] + ") shouldn't be bigger than fluidLeavingSide[" + i + "](=" + this.fluidLeavingSide[i] + ")";
            }
            return super.checkStateForErrors();
        }
    }

    public static class PreMoveToCentre
    extends PipeEventFluid {
        public final FluidStack fluid;
        public final int totalAcceptable;
        public final int[] totalOffered;
        private final int[] totalOfferedCheck;
        public final int[] actuallyOffered;

        public PreMoveToCentre(IPipeHolder holder, IFlowFluid flow, FluidStack fluid, int totalAcceptable, int[] totalOffered, int[] actuallyOffered) {
            super(holder, flow);
            this.fluid = fluid;
            this.totalAcceptable = totalAcceptable;
            this.totalOffered = totalOffered;
            this.totalOfferedCheck = Arrays.copyOf(totalOffered, totalOffered.length);
            this.actuallyOffered = actuallyOffered;
        }

        @Override
        public String checkStateForErrors() {
            for (int i = 0; i < this.totalOffered.length; ++i) {
                if (this.totalOffered[i] != this.totalOfferedCheck[i]) {
                    return "Changed totalOffered";
                }
                if (this.actuallyOffered[i] <= this.totalOffered[i]) continue;
                return "actuallyOffered[" + i + "](=" + this.actuallyOffered[i] + ") shouldn't be greater than totalOffered[" + i + "](=" + this.totalOffered[i] + ")";
            }
            return super.checkStateForErrors();
        }
    }

    public static class TryInsert
    extends PipeEventFluid {
        public final EnumFacing from;
        @Nonnull
        public final FluidStack fluid;

        public TryInsert(IPipeHolder holder, IFlowFluid flow, EnumFacing from, @Nonnull FluidStack fluid) {
            super(true, holder, flow);
            this.from = from;
            this.fluid = fluid;
        }
    }
}

