/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.addon;

import buildcraft.api.core.IBox;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.containers.IFillerStatementContainer;
import buildcraft.builders.BCBuildersGuis;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.builders.addon.AddonRendererFillerPlanner;
import buildcraft.builders.filler.FillerType;
import buildcraft.builders.filler.FillerUtil;
import buildcraft.builders.snapshot.Template;
import buildcraft.core.marker.volume.Addon;
import buildcraft.core.marker.volume.AddonDefaultRenderer;
import buildcraft.core.marker.volume.IFastAddonRenderer;
import buildcraft.core.marker.volume.ISingleAddon;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.FullStatement;
import java.io.IOException;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class AddonFillerPlanner
extends Addon
implements ISingleAddon,
IFillerStatementContainer {
    public final FullStatement<IFillerPattern> patternStatement = new FullStatement<IFillerPattern>(FillerType.INSTANCE, 4, null);
    public boolean inverted;
    @Nullable
    public Template.BuildingInfo buildingInfo;

    public void updateBuildingInfo() {
        this.buildingInfo = FillerUtil.createBuildingInfo(this, this.patternStatement, (IStatementParameter[])IntStream.range(0, this.patternStatement.maxParams).mapToObj(this.patternStatement::get).toArray(IStatementParameter[]::new), this.inverted);
    }

    @Override
    public void onVolumeBoxSizeChange() {
        this.updateBuildingInfo();
    }

    public IFastAddonRenderer<AddonFillerPlanner> getRenderer() {
        return new AddonDefaultRenderer<AddonFillerPlanner>(BCBuildersSprites.FILLER_PLANNER.getSprite()).then(new AddonRendererFillerPlanner());
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.updateBuildingInfo();
    }

    @Override
    public void postReadFromNbt() {
        super.postReadFromNbt();
        this.updateBuildingInfo();
    }

    @Override
    public void onPlayerRightClick(EntityPlayer player) {
        super.onPlayerRightClick(player);
        BCBuildersGuis.FILLER_PLANNER.openGUI(player);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("patternStatement", (NBTBase)this.patternStatement.writeToNbt());
        nbt.func_74757_a("inverted", this.inverted);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.patternStatement.readFromNbt(nbt.func_74775_l("patternStatement"));
        this.inverted = nbt.func_74767_n("inverted");
    }

    @Override
    public void toBytes(PacketBufferBC buf) {
        this.patternStatement.writeToBuffer(buf);
        buf.writeBoolean(this.inverted);
    }

    @Override
    public void fromBytes(PacketBufferBC buf) throws IOException {
        this.patternStatement.readFromBuffer(buf);
        this.inverted = buf.readBoolean();
        this.updateBuildingInfo();
    }

    @Override
    public TileEntity getNeighbourTile(EnumFacing side) {
        return null;
    }

    @Override
    public TileEntity getTile() {
        return null;
    }

    @Override
    public World getFillerWorld() {
        return this.volumeBox.world;
    }

    @Override
    public boolean hasBox() {
        return true;
    }

    @Override
    public IBox getBox() {
        return this.volumeBox.box;
    }

    @Override
    public void setPattern(IFillerPattern pattern, IStatementParameter[] params) {
        this.patternStatement.set(pattern);
        IntStream.range(0, this.patternStatement.maxParams).forEach(i -> this.patternStatement.set(i, params[i]));
        this.updateBuildingInfo();
    }
}

