/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.BCModules;
import buildcraft.api.IBuildCraftMod;
import buildcraft.core.BCCoreGuis;
import buildcraft.core.BCCoreModels;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.client.RenderTickListener;
import buildcraft.core.client.render.RenderVolumeBoxes;
import buildcraft.core.list.ContainerList;
import buildcraft.core.list.GuiList;
import buildcraft.core.list.ListTooltipHandler;
import buildcraft.core.marker.volume.ClientVolumeBoxes;
import buildcraft.core.marker.volume.MessageVolumeBoxes;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.core.marker.volume.WorldSavedDataVolumeBoxes;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.net.MessageManager;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BCCoreProxy
implements IGuiHandler {
    @SidedProxy(modId="buildcraftcore")
    private static BCCoreProxy proxy = null;

    public static BCCoreProxy getProxy() {
        return proxy;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == BCCoreGuis.LIST.ordinal()) {
            return new ContainerList(player);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void fmlPreInit() {
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.CORE, MessageVolumeBoxes.class, Side.CLIENT);
    }

    public void fmlInit() {
    }

    public void fmlPostInit() {
    }

    public List<VolumeBox> getVolumeBoxes(World world) {
        return WorldSavedDataVolumeBoxes.get((World)world).volumeBoxes;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends BCCoreProxy {
        @Override
        public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
            if (ID == BCCoreGuis.LIST.ordinal()) {
                return new GuiList(player);
            }
            return null;
        }

        @Override
        public void fmlPreInit() {
            super.fmlPreInit();
            BCCoreSprites.fmlPreInit();
            BCCoreModels.fmlPreInit();
            DetachedRenderer.INSTANCE.addRenderer(DetachedRenderer.RenderMatrixType.FROM_WORLD_ORIGIN, RenderVolumeBoxes.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)ListTooltipHandler.INSTANCE);
            MessageManager.setHandler(MessageVolumeBoxes.class, MessageVolumeBoxes.HANDLER, Side.CLIENT);
        }

        @Override
        public void fmlInit() {
            BCCoreModels.fmlInit();
            MinecraftForge.EVENT_BUS.register(RenderTickListener.class);
        }

        @Override
        public List<VolumeBox> getVolumeBoxes(World world) {
            return world.field_72995_K ? ClientVolumeBoxes.INSTANCE.volumeBoxes : super.getVolumeBoxes(world);
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerProxy
    extends BCCoreProxy {
    }
}

