/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.api.core.BCLog;
import buildcraft.factory.container.ContainerAutoCraftItems;
import buildcraft.factory.tile.TileAutoWorkbenchItems;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.ledger.LedgerHelp;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.recipe.GuiRecipeBookPhantom;
import buildcraft.lib.gui.slot.SlotBase;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.recipebook.GuiRecipeBook;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class GuiAutoCraftItems
extends GuiBC8<ContainerAutoCraftItems>
implements IRecipeShownListener {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftfactory:textures/gui/autobench_item.png");
    private static final ResourceLocation TEXTURE_MISC = new ResourceLocation("buildcraftlib:textures/gui/misc_slots.png");
    private static final ResourceLocation VANILLA_CRAFTING_TABLE = new ResourceLocation("textures/gui/container/crafting_table.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 197;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE_BASE, 0.0, 0.0, 176.0, 197.0);
    private static final GuiIcon ICON_FILTER_OVERLAY_SAME = new GuiIcon(TEXTURE_MISC, 54.0, 0.0, 18.0, 18.0);
    private static final GuiIcon ICON_FILTER_OVERLAY_DIFFERENT = new GuiIcon(TEXTURE_MISC, 72.0, 0.0, 18.0, 18.0);
    private static final GuiIcon ICON_PROGRESS = new GuiIcon(TEXTURE_BASE, 176.0, 0.0, 23.0, 10.0);
    private static final GuiRectangle RECT_PROGRESS = new GuiRectangle(90.0, 47.0, 23.0, 10.0);
    private final GuiRecipeBookPhantom recipeBook;
    private boolean widthTooNarrow;
    private GuiButtonImage recipeButton;

    public GuiAutoCraftItems(ContainerAutoCraftItems container) {
        super(container);
        GuiRecipeBookPhantom book;
        this.field_146999_f = 176;
        this.field_147000_g = 197;
        try {
            book = new GuiRecipeBookPhantom(this::sendRecipe);
        }
        catch (ReflectiveOperationException e) {
            BCLog.logger.warn("[factory.gui] An exception was thrown while creating the recipe book gui!", (Throwable)e);
            book = null;
        }
        this.recipeBook = book;
        this.mainGui.shownElements.add(new LedgerHelp(this.mainGui, true));
    }

    private void sendRecipe(IRecipe recipe) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(9);
        int maxX = recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : 3;
        int maxY = recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeHeight() : 3;
        int offsetX = maxX == 1 ? 1 : 0;
        int offsetY = maxY == 1 ? 1 : 0;
        NonNullList ingredients = recipe.func_192400_c();
        if (ingredients.isEmpty()) {
            return;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (x < offsetX || y < offsetY) {
                    stacks.add(ItemStack.field_190927_a);
                    continue;
                }
                int i = x - offsetX + (y - offsetY) * maxX;
                if (i >= ingredients.size() || x - offsetX >= maxX) {
                    stacks.add(ItemStack.field_190927_a);
                    continue;
                }
                Ingredient ing = (Ingredient)ingredients.get(i);
                ItemStack[] matching = ing.func_193365_a();
                if (matching.length >= 1) {
                    stacks.add(matching[0]);
                    continue;
                }
                stacks.add(ItemStack.field_190927_a);
            }
        }
        ((ContainerAutoCraftItems)this.container).sendSetPhantomSlots(((TileAutoWorkbenchItems)((ContainerAutoCraftItems)this.container).tile).invBlueprint, stacks);
    }

    @Override
    protected boolean shouldAddHelpLedger() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        boolean bl = this.widthTooNarrow = this.field_146294_l < 352;
        if (this.recipeBook != null) {
            InventoryCrafting invCraft = ((TileAutoWorkbenchItems)((ContainerAutoCraftItems)this.container).tile).getWorkbenchCrafting();
            this.recipeBook.func_194303_a(this.field_146294_l, this.field_146295_m, this.field_146297_k, this.widthTooNarrow, invCraft);
            this.field_147003_i = this.recipeBook.func_193011_a(this.widthTooNarrow, this.field_146294_l, this.field_146999_f);
            this.recipeButton = new GuiButtonImage(10, this.field_147003_i + 5, this.field_146295_m / 2 - 66, 20, 18, 0, 168, 19, VANILLA_CRAFTING_TABLE);
            this.field_146292_n.add(this.recipeButton);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.recipeBook != null) {
            this.recipeBook.func_193957_d();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.recipeBook == null) {
            super.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        if (this.recipeBook.func_191878_b() && this.widthTooNarrow) {
            this.func_146276_q_();
            this.func_146976_a(partialTicks, mouseX, mouseY);
            this.recipeBook.func_191861_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        } else {
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.recipeBook.func_191861_a(mouseX, mouseY, partialTicks);
            this.recipeBook.func_191864_a(this.field_147003_i, this.field_147009_r, true, partialTicks);
        }
        this.recipeBook.func_191876_c(this.field_147003_i, this.field_147009_r, mouseX, mouseY);
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt(this.mainGui.rootElement);
        double progress = ((TileAutoWorkbenchItems)((ContainerAutoCraftItems)this.container).tile).getProgress(partialTicks);
        this.drawProgress(RECT_PROGRESS, ICON_PROGRESS, progress, 1.0);
        if (this.hasFilters()) {
            RenderHelper.func_74520_c();
            this.forEachFilter((slot, filterStack) -> {
                int x = slot.field_75223_e + (int)this.mainGui.rootElement.getX();
                int y = slot.field_75221_f + (int)this.mainGui.rootElement.getY();
                this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, filterStack, x, y);
                this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, filterStack, x, y, null);
            });
            RenderHelper.func_74518_a();
            GlStateManager.func_179097_i();
            this.forEachFilter((slot, filterStack) -> {
                ItemStack real = slot.func_75211_c();
                GuiIcon icon = real.func_190926_b() || StackUtil.canMerge(real, filterStack) ? ICON_FILTER_OVERLAY_SAME : ICON_FILTER_OVERLAY_DIFFERENT;
                int x = slot.field_75223_e + (int)this.mainGui.rootElement.getX();
                int y = slot.field_75221_f + (int)this.mainGui.rootElement.getY();
                icon.drawAt(x - 1, y - 1);
            });
            GlStateManager.func_179126_j();
        }
    }

    private boolean hasFilters() {
        ItemHandlerSimple filters = ((TileAutoWorkbenchItems)((ContainerAutoCraftItems)this.container).tile).invMaterialFilter;
        for (int s = 0; s < filters.getSlots(); ++s) {
            ItemStack filter = filters.getStackInSlot(s);
            if (filter.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private void forEachFilter(IFilterSlotIterator iter) {
        ItemHandlerSimple filters = ((TileAutoWorkbenchItems)((ContainerAutoCraftItems)this.container).tile).invMaterialFilter;
        for (int s = 0; s < filters.getSlots(); ++s) {
            ItemStack filter = filters.getStackInSlot(s);
            if (filter.func_190926_b()) continue;
            iter.iterate(((ContainerAutoCraftItems)this.container).materialSlots[s], filter);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.recipeButton && this.recipeBook != null) {
            this.recipeBook.func_193014_a(this.widthTooNarrow, ((TileAutoWorkbenchItems)((ContainerAutoCraftItems)this.container).tile).getWorkbenchCrafting());
            this.recipeBook.func_191866_a();
            this.field_147003_i = this.recipeBook.func_193011_a(this.widthTooNarrow, this.field_146294_l, this.field_146999_f);
            this.recipeButton.func_191746_c(this.field_147003_i + 5, this.field_146295_m / 2 - 66);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.recipeBook == null) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            return;
        }
        if (!(this.recipeBook.func_191862_a(mouseX, mouseY, mouseButton) || this.widthTooNarrow && this.recipeBook.func_191878_b())) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.recipeBook == null) {
            super.func_73869_a(typedChar, keyCode);
            return;
        }
        if (!this.recipeBook.func_191859_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slot, slotId, mouseButton, type);
        if (this.recipeBook != null) {
            this.recipeBook.func_191874_a(slot);
        }
    }

    protected boolean func_146978_c(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        if (this.recipeBook == null) {
            return super.func_146978_c(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
        }
        return (!this.widthTooNarrow || !this.recipeBook.func_191878_b()) && super.func_146978_c(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    protected boolean func_193983_c(int mouseX, int mouseY, int _guiLeft, int _guiTop) {
        if (this.recipeBook == null) {
            return super.func_193983_c(mouseX, mouseY, _guiLeft, _guiTop);
        }
        boolean flag = mouseX < _guiLeft || mouseY < _guiTop || mouseX >= _guiLeft + this.field_146999_f || mouseY >= _guiTop + this.field_147000_g;
        return this.recipeBook.func_193955_c(mouseX, mouseY, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g) && flag;
    }

    public void func_146281_b() {
        if (this.recipeBook != null) {
            this.recipeBook.func_191871_c();
        }
        super.func_146281_b();
    }

    public void func_192043_J_() {
        if (this.recipeBook != null) {
            this.recipeBook.func_193948_e();
        }
    }

    public GuiRecipeBook func_194310_f() {
        return this.recipeBook;
    }

    @FunctionalInterface
    private static interface IFilterSlotIterator {
        public void iterate(SlotBase var1, ItemStack var2);
    }
}

