/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IFluidFilter;
import buildcraft.api.core.IFluidHandlerAdv;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTank
extends TileBC_Neptune
implements ITickable,
IDebuggable,
IFluidHandlerAdv {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("tank");
    public static final int NET_FLUID_DELTA = IDS.allocId("FLUID_DELTA");
    private static boolean isPlayerInteracting = false;
    public final Tank tank;
    public final FluidSmoother smoothedTank;
    private int lastComparatorLevel;

    public TileTank() {
        this(16000);
    }

    protected TileTank(int capacity) {
        this(new Tank("tank", capacity, null));
    }

    protected TileTank(Tank tank) {
        tank.setTileEntity(this);
        this.tank = tank;
        this.tankManager.add(tank);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this, EnumPipePart.VALUES);
        this.smoothedTank = new FluidSmoother(w -> this.createAndSendMessage(NET_FLUID_DELTA, w), tank);
    }

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public int getComparatorLevel() {
        int amount = this.tank.getFluidAmount();
        int cap = this.tank.getCapacity();
        return amount * 14 / cap + (amount > 0 ? 1 : 0);
    }

    public void func_73660_a() {
        int compLevel;
        this.smoothedTank.tick(this.field_145850_b);
        if (!this.field_145850_b.field_72995_K && (compLevel = this.getComparatorLevel()) != this.lastComparatorLevel) {
            this.lastComparatorLevel = compLevel;
            this.func_70296_d();
        }
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        super.onPlacedBy(placer, stack);
        if (!placer.field_70170_p.field_72995_K) {
            isPlayerInteracting = true;
            this.balanceTankFluids();
            isPlayerInteracting = false;
        }
    }

    public void balanceTankFluids() {
        List<TileTank> tanks = this.getTanks();
        FluidStack fluid = null;
        for (TileTank tile : tanks) {
            FluidStack held = tile.tank.getFluid();
            if (held == null) continue;
            if (fluid == null) {
                fluid = held;
                continue;
            }
            if (fluid.isFluidEqual(held)) continue;
            return;
        }
        if (fluid == null) {
            return;
        }
        if (fluid.getFluid().isGaseous(fluid)) {
            Collections.reverse(tanks);
        }
        TileTank prev = null;
        for (TileTank tile : tanks) {
            if (prev != null) {
                FluidUtilBC.move(tile.tank, prev.tank);
            }
            prev = tile;
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        isPlayerInteracting = true;
        boolean didChange = FluidUtilBC.onTankActivated(player, this.field_174879_c, hand, this);
        isPlayerInteracting = false;
        return didChange;
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_FLUID_DELTA, buffer, side);
            } else if (id == NET_FLUID_DELTA) {
                this.smoothedTank.writeInit(buffer);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_FLUID_DELTA, buffer, side, ctx);
                this.smoothedTank.resetSmoothing(this.func_145831_w());
            } else if (id == NET_FLUID_DELTA) {
                this.smoothedTank.handleMessage(this.func_145831_w(), buffer);
            }
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("fluid = " + this.tank.getDebugString());
        this.smoothedTank.getDebugInfo(left, right, side);
    }

    @SideOnly(value=Side.CLIENT)
    public FluidSmoother.FluidStackInterp getFluidForRender(float partialTicks) {
        return this.smoothedTank.getFluidForRender(partialTicks);
    }

    public boolean canConnectTo(TileTank other, EnumFacing direction) {
        return true;
    }

    public static boolean canTanksConnect(TileTank from, TileTank to, EnumFacing direction) {
        return from.canConnectTo(to, direction) && to.canConnectTo(from, direction.func_176734_d());
    }

    private List<TileTank> getTanks() {
        TileTank tankBelow;
        TileEntity tileBelow;
        TileTank tankUp;
        TileEntity tileAbove;
        ArrayDeque<TileTank> tanks = new ArrayDeque<TileTank>();
        tanks.add(this);
        TileTank prevTank = this;
        while ((tileAbove = prevTank.getNeighbourTile(EnumFacing.UP)) instanceof TileTank && (tankUp = (TileTank)tileAbove) != null && TileTank.canTanksConnect(prevTank, tankUp, EnumFacing.UP)) {
            tanks.addLast(tankUp);
            prevTank = tankUp;
        }
        prevTank = this;
        while ((tileBelow = prevTank.getNeighbourTile(EnumFacing.DOWN)) instanceof TileTank && (tankBelow = (TileTank)tileBelow) != null && TileTank.canTanksConnect(prevTank, tankBelow, EnumFacing.DOWN)) {
            tanks.addFirst(tankBelow);
            prevTank = tankBelow;
        }
        return new ArrayList<TileTank>(tanks);
    }

    public IFluidTankProperties[] getTankProperties() {
        List<TileTank> tanks = this.getTanks();
        TileTank bottom = tanks.get(0);
        TileTank top = tanks.get(tanks.size() - 1);
        FluidStack total = bottom.tank.getFluid();
        if (total == null) {
            total = top.tank.getFluid();
        }
        int capacity = 0;
        if (total == null) {
            for (TileTank t : tanks) {
                capacity += t.tank.getCapacity();
            }
        } else {
            total = total.copy();
            total.amount = 0;
            for (TileTank t : tanks) {
                FluidStack other = t.tank.getFluid();
                if (other != null) {
                    total.amount += other.amount;
                }
                capacity += t.tank.getCapacity();
            }
        }
        return new IFluidTankProperties[]{new FluidTankProperties(total, capacity)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        int filled = 0;
        List<TileTank> tanks = this.getTanks();
        for (TileTank t : tanks) {
            FluidStack current = t.tank.getFluid();
            if (current == null || current.isFluidEqual(resource)) continue;
            return 0;
        }
        boolean gas = resource.getFluid().isGaseous(resource);
        if (gas) {
            Collections.reverse(tanks);
        }
        resource = resource.copy();
        for (TileTank t : tanks) {
            int tankFilled = t.tank.fill(resource, doFill);
            if (tankFilled <= 0) continue;
            if (isPlayerInteracting & doFill) {
                t.sendNetworkUpdate(NET_RENDER_DATA);
            }
            resource.amount -= tankFilled;
            filled += tankFilled;
            if (resource.amount != 0) continue;
            break;
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(fluid -> true, maxDrain, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        return this.drain(arg_0 -> ((FluidStack)resource).isFluidEqual(arg_0), resource.amount, doDrain);
    }

    @Override
    public FluidStack drain(IFluidFilter filter, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        List<TileTank> tanks = this.getTanks();
        boolean gas = false;
        for (TileTank tile : tanks) {
            FluidStack fluid = tile.tank.getFluid();
            if (fluid == null) continue;
            gas = fluid.getFluid().isGaseous(fluid);
            break;
        }
        if (!gas) {
            Collections.reverse(tanks);
        }
        FluidStack total = null;
        for (TileTank t : tanks) {
            int realMax = maxDrain - (total == null ? 0 : total.amount);
            if (realMax <= 0) break;
            FluidStack drained = t.tank.drain(filter, realMax, doDrain);
            if (drained == null) continue;
            if (isPlayerInteracting & doDrain) {
                t.sendNetworkUpdate(NET_RENDER_DATA);
            }
            if (total == null) {
                total = drained.copy();
                total.amount = 0;
            }
            total.amount += drained.amount;
        }
        return total;
    }
}

