/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib;

import buildcraft.api.BCModules;
import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibEventDist;
import buildcraft.lib.BCLibItems;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.BCLibRegistries;
import buildcraft.lib.block.VanillaPaintHandlers;
import buildcraft.lib.block.VanillaRotationHandlers;
import buildcraft.lib.chunkload.ChunkLoaderManager;
import buildcraft.lib.command.CommandBuildCraft;
import buildcraft.lib.expression.ExpressionDebugManager;
import buildcraft.lib.fluid.FluidManager;
import buildcraft.lib.list.VanillaListHandlers;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.misc.ExpressionCompat;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.lib.registry.MigrationManager;
import buildcraft.lib.registry.RegistrationHelper;
import buildcraft.lib.registry.TagManager;
import java.util.function.Consumer;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="buildcraftlib", name="BuildCraft Lib", version="7.99.19", updateJSON="https://mod-buildcraft.com/version/versions.json", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forge@[14.23.0.2544,)")
public class BCLib {
    public static final String MODID = "buildcraftlib";
    public static final String VERSION = "7.99.19";
    public static final String MC_VERSION = "1.12.2";
    public static final String GIT_BRANCH = "HEAD";
    public static final String GIT_COMMIT_HASH = "a133775732fee3526618bc7dba9b007a55454a9e";
    public static final String GIT_COMMIT_MSG = "Bump version for 7.99.19 release.";
    public static final String GIT_COMMIT_AUTHOR = "AlexIIL";
    public static final boolean DEV = "7.99.19".startsWith("$") || Boolean.getBoolean("buildcraft.dev");
    @Mod.Instance(value="buildcraftlib")
    public static BCLib INSTANCE;
    public static ModContainer MOD_CONTAINER;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) {
        MOD_CONTAINER = Loader.instance().activeModContainer();
        BCLog.logger.info("");
        BCLog.logger.info("Starting BuildCraft 7.99.19");
        BCLog.logger.info("Copyright (c) the BuildCraft team, 2011-2018");
        BCLog.logger.info("https://www.mod-buildcraft.com");
        if (!GIT_COMMIT_HASH.startsWith("${")) {
            BCLog.logger.info("Detailed Build Information:");
            BCLog.logger.info("  Branch HEAD");
            BCLog.logger.info("  Commit a133775732fee3526618bc7dba9b007a55454a9e");
            BCLog.logger.info("    Bump version for 7.99.19 release.");
            BCLog.logger.info("    committed by AlexIIL");
        }
        BCLog.logger.info("");
        BCLog.logger.info("Loaded Modules:");
        for (BCModules module : BCModules.VALUES) {
            if (!module.isLoaded()) continue;
            BCLog.logger.info("  - " + module.lowerCaseName);
        }
        BCLog.logger.info("Missing Modules:");
        for (BCModules module : BCModules.VALUES) {
            if (module.isLoaded()) continue;
            BCLog.logger.info("  - " + module.lowerCaseName);
        }
        BCLog.logger.info("");
        ExpressionDebugManager.logger = arg_0 -> ((Logger)BCLog.logger).info(arg_0);
        ExpressionCompat.setup();
        BCLibRegistries.fmlPreInit();
        BCLibProxy.getProxy().fmlPreInit();
        BCLibItems.fmlPreInit();
        BuildCraftObjectCaches.fmlPreInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)BCLibProxy.getProxy());
        MinecraftForge.EVENT_BUS.register(BCLibEventDist.class);
        MinecraftForge.EVENT_BUS.register((Object)MigrationManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register(FluidManager.class);
        ForgeChunkManager.getConfig().get(MODID, "maximumChunksPerTicket", 26);
        ForgeChunkManager.syncConfigDefaults();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)INSTANCE, ChunkLoaderManager::rebindTickets);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        BCLibProxy.getProxy().fmlInit();
        BCLibRegistries.fmlInit();
        VanillaListHandlers.fmlInit();
        VanillaPaintHandlers.fmlInit();
        VanillaRotationHandlers.fmlInit();
        RegistrationHelper.registerOredictEntries();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        BCLibProxy.getProxy().fmlPostInit();
        BuildCraftObjectCaches.fmlPostInit();
        VanillaListHandlers.fmlPostInit();
        MarkerCache.postInit();
        MessageManager.fmlPostInit();
    }

    @Mod.EventHandler
    public static void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBuildCraft());
    }

    private static TagManager.TagEntry registerTag(String id) {
        return TagManager.registerTag(id);
    }

    private static void startBatch() {
        TagManager.startBatch();
    }

    private static void endBatch(Consumer<TagManager.TagEntry> consumer) {
        TagManager.endBatch(consumer);
    }

    static {
        BCLib.startBatch();
        BCLib.registerTag("item.guide").reg("guide").locale("buildcraft.guide").model("guide").tab("vanilla.misc");
        BCLib.registerTag("item.guide.note").reg("guide_note").locale("buildcraft.guide_note").model("guide_note").tab("vanilla.misc");
        BCLib.registerTag("item.debugger").reg("debugger").locale("debugger").model("debugger").tab("vanilla.misc");
        BCLib.endBatch(TagManager.prependTags("buildcraftlib:", TagManager.EnumTagType.REGISTRY_NAME, TagManager.EnumTagType.MODEL_LOCATION));
    }
}

