/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide;

import buildcraft.api.BCModules;
import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.PageEntry;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.TypeOrder;
import buildcraft.lib.client.guide.data.JsonContents;
import buildcraft.lib.client.guide.data.JsonEntry;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import buildcraft.lib.client.guide.loader.IPageLoader;
import buildcraft.lib.client.guide.loader.MarkdownPageLoader;
import buildcraft.lib.client.guide.loader.entry.IEntryLinkConsumer;
import buildcraft.lib.client.guide.loader.entry.PageEntryType;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePageStandInRecipes;
import buildcraft.lib.client.guide.parts.contents.ContentsNode;
import buildcraft.lib.client.guide.parts.contents.ContentsNodeGui;
import buildcraft.lib.client.guide.parts.contents.GuidePageContents;
import buildcraft.lib.client.guide.parts.contents.IContentsNode;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.client.guide.parts.contents.PageLinkNormal;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.misc.LocaleUtil;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.Language;
import net.minecraft.client.util.SuffixArray;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public enum GuideManager implements IResourceManagerReloadListener
{
    INSTANCE;

    public static final List<String> loadedDomains;
    public static final List<String> loadedMods;
    public static final List<String> loadedOther;
    public static final Set<BCModules> buildCraftModules;
    public static final String DEFAULT_LANG = "en_us";
    public static final Map<String, IPageLoader> PAGE_LOADERS;
    private final List<PageEntry<?>> entries = new ArrayList();
    private final Map<String, GuidePageFactory> pages = new HashMap<String, GuidePageFactory>();
    private final Map<ItemStack, GuidePageFactory> generatedPages = new HashMap<ItemStack, GuidePageFactory>();
    public static final boolean DEBUG;
    public SuffixArray<PageLink> quickSearcher;
    private final Map<TypeOrder, ContentsNode> contents = new HashMap<TypeOrder, ContentsNode>();
    public final Set<Object> objectsAdded = new HashSet<Object>();

    public void func_110549_a(IResourceManager resourceManager) {
        this.reload(resourceManager);
    }

    public void reload() {
        this.reload(Minecraft.func_71410_x().func_110442_L());
    }

    private void reload(IResourceManager resourceManager) {
        String langCode;
        int maxModuleCount;
        Stopwatch watch = Stopwatch.createStarted();
        this.entries.clear();
        loadedDomains.clear();
        loadedMods.clear();
        loadedOther.clear();
        List<JsonEntry> loaded = GuideManager.loadAll(resourceManager);
        for (JsonEntry entry : loaded) {
            PageEntry<?> pageEntry = PageEntry.createPageEntry(entry);
            if (pageEntry == null) continue;
            this.entries.add(pageEntry);
        }
        Collections.sort(loadedDomains);
        buildCraftModules.clear();
        for (BCModules module : BCModules.VALUES) {
            if (!loadedDomains.remove(module.getModId())) continue;
            buildCraftModules.add(module);
        }
        int moduleCount = buildCraftModules.size();
        if (moduleCount == (maxModuleCount = BCModules.VALUES.length)) {
            loadedMods.add("BuildCraft (+Compat)");
        } else if (moduleCount == maxModuleCount - 1 && !buildCraftModules.contains(BCModules.COMPAT)) {
            loadedMods.add("BuildCraft");
        } else if (moduleCount > 2) {
            loadedMods.add("BuildCraft (\u00a7o" + (moduleCount - 2) + " modules\u00a7r)");
        } else if (moduleCount == 2) {
            loadedMods.add("BuildCraft (Core)");
        } else {
            loadedMods.add("BuildCraft (Lib)");
        }
        for (String domain : loadedDomains) {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(domain);
            if (mod != null) {
                loadedMods.add(mod.getName());
                continue;
            }
            loadedOther.add(LocaleUtil.localize(domain + ".compat.buildcraft.guide.domain_name"));
        }
        this.pages.clear();
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (currentLanguage == null) {
            BCLog.logger.warn("Current language was null!");
            langCode = DEFAULT_LANG;
        } else {
            langCode = currentLanguage.func_135034_a();
        }
        this.loadLangInternal(resourceManager, DEFAULT_LANG);
        if (!DEFAULT_LANG.equals(langCode)) {
            this.loadLangInternal(resourceManager, langCode);
        }
        this.generateContentsPage();
        watch.stop();
        long time = watch.elapsed(TimeUnit.MILLISECONDS);
        int p = this.entries.size();
        int a = this.pages.size();
        int e = p - a;
        BCLog.logger.info("[lib.guide] Loaded " + p + " possible and " + a + " actual guide pages (" + e + " not found) in " + time + "ms.");
    }

    private static List<JsonEntry> loadAll(IResourceManager resourceManager) {
        ArrayList<JsonEntry> allEntries = new ArrayList<JsonEntry>();
        for (String domain : resourceManager.func_135055_a()) {
            JsonContents contents = GuideManager.loadContents(resourceManager, domain);
            if (contents == null) continue;
            loadedDomains.add(domain);
            contents = contents.inheritMissingTags();
            for (JsonEntry entry : contents.contents) {
                allEntries.add(entry);
            }
        }
        return allEntries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonContents loadContents(IResourceManager resourceManager, String domain) {
        ResourceLocation location = new ResourceLocation(domain, "compat/buildcraft/guide/contents.json");
        try (InputStream is = resourceManager.func_110536_a(location).func_110527_b();){
            if (is != null) {
                InputStreamReader isr = new InputStreamReader(is);
                JsonContents jsonContents2 = (JsonContents)new Gson().fromJson((Reader)isr, JsonContents.class);
                return jsonContents2;
            }
            JsonContents jsonContents = null;
            return jsonContents;
        }
        catch (FileNotFoundException fnfe) {
            if (!DEBUG) return null;
            BCLog.logger.warn("[lib.guide.loader] Looks like there is no guide contents page for " + location + ", skipping.");
            return null;
        }
        catch (IOException io) {
            if (DEBUG) {
                BCLog.logger.warn("[lib.guide.loader] Failed to load the contents file for " + domain + "!", (Throwable)io);
                return null;
            }
            BCLog.logger.warn("[lib.guide.loader] Failed to load the contents file for " + domain + ": " + io.getMessage());
            return null;
        }
    }

    private void loadLangInternal(IResourceManager resourceManager, String lang) {
        for (PageEntry<?> data : this.entries) {
            String page = data.page.replaceAll("<lang>", lang);
            String ending = page.substring(page.lastIndexOf(46) + 1);
            IPageLoader loader = PAGE_LOADERS.get(ending);
            if (loader == null) {
                BCLog.logger.warn("[lib.guide.loader] Unable to load guide page '" + page + "', as we don't know how to load it! (Known file type endings are " + PAGE_LOADERS.keySet() + ")");
                continue;
            }
            try {
                InputStream stream = resourceManager.func_110536_a(new ResourceLocation(page)).func_110527_b();
                Throwable throwable = null;
                try {
                    GuidePageFactory factory = loader.loadPage(stream, data);
                    this.pages.put(data.page, factory);
                    if (!DEBUG) continue;
                    BCLog.logger.info("[lib.guide.loader] Loaded page '" + page + "'.");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                BCLog.logger.warn("[lib.guide.loader] Unable to load guide page '" + page + "' because we couldn't find it in any resource pack!");
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
    }

    private void generateContentsPage() {
        this.objectsAdded.clear();
        this.contents.clear();
        for (TypeOrder order : GuiGuide.SORTING_TYPES) {
            this.contents.put(order, new ContentsNode("root", -1));
        }
        this.quickSearcher = new SuffixArray();
        for (PageEntry entry : INSTANCE.getAllEntries()) {
            GuidePageFactory entryFactory = INSTANCE.getFactoryFor(entry);
            String translatedTitle = LocaleUtil.localize(entry.title);
            ISimpleDrawable icon = entry.createDrawable();
            PageLine line = new PageLine(icon, icon, 2, translatedTitle, true);
            if (entryFactory == null) continue;
            this.objectsAdded.add(entry.getBasicValue());
            PageLinkNormal pageLink = new PageLinkNormal(line, true, entry.getTooltip(), entryFactory);
            this.addChild(entry.typeTags, pageLink);
        }
        IEntryLinkConsumer adder = this::addChild;
        for (PageEntryType<?> type : new HashSet(PageEntryType.REGISTRY.values())) {
            type.iterateAllDefault(adder);
        }
        this.quickSearcher.func_194058_a();
        for (ContentsNode node : this.contents.values()) {
            node.sort();
        }
    }

    private void addChild(JsonTypeTags tags, PageLink page) {
        for (Map.Entry<TypeOrder, ContentsNode> entry : this.contents.entrySet()) {
            TypeOrder order = entry.getKey();
            ContentsNode node = entry.getValue();
            String[] ordered = tags.getOrdered(order);
            for (int i = 0; i < ordered.length; ++i) {
                String title = LocaleUtil.localize(ordered[i]);
                IContentsNode subNode = node.getChild(title);
                if (subNode instanceof ContentsNode) {
                    node = (ContentsNode)subNode;
                    continue;
                }
                if (subNode == null) {
                    ContentsNode subContents = new ContentsNode(title, i);
                    node.addChild(subContents);
                    node = subContents;
                    continue;
                }
                throw new IllegalStateException("Unknown node type " + subNode.getClass());
            }
            node.addChild(page);
            this.quickSearcher.func_194057_a((Object)page, page.getSearchName());
        }
    }

    public ImmutableList<PageEntry<?>> getAllEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public GuidePageFactory getFactoryFor(PageEntry<?> entry) {
        return this.pages.get(entry.page);
    }

    public PageEntry<?> getEntryFor(Object obj) {
        for (PageEntry<?> entry : this.entries) {
            if (!entry.matches(obj)) continue;
            return entry;
        }
        return null;
    }

    @Nonnull
    public GuidePageFactory getPageFor(@Nonnull ItemStack stack) {
        GuidePageFactory factory;
        PageEntry<?> entry = this.getEntryFor(stack);
        if (entry != null && (factory = this.getFactoryFor(entry)) != null) {
            return factory;
        }
        return this.generatedPages.computeIfAbsent(stack, GuidePageStandInRecipes::createFactory);
    }

    public ContentsNodeGui getGuiContents(GuiGuide gui, GuidePageContents guidePageContents, TypeOrder sortingOrder) {
        ContentsNode node = this.contents.get(sortingOrder);
        if (node == null) {
            throw new IllegalStateException("Unknown sorting order " + sortingOrder);
        }
        node.resetVisibility();
        return new ContentsNodeGui(gui, guidePageContents, node);
    }

    static {
        loadedDomains = new ArrayList<String>();
        loadedMods = new ArrayList<String>();
        loadedOther = new ArrayList<String>();
        buildCraftModules = EnumSet.noneOf(BCModules.class);
        PAGE_LOADERS = new HashMap<String, IPageLoader>();
        DEBUG = BCDebugging.shouldDebugLog("lib.guide.loader");
        PAGE_LOADERS.put("md", MarkdownPageLoader.INSTANCE);
    }
}

