/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.data.JsonEntry;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import buildcraft.lib.client.guide.loader.entry.PageEntryType;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.misc.ColourUtil;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.util.StringUtils;

public class PageEntry<T> {
    public final String title;
    public final String page;
    public final JsonTypeTags typeTags;
    public final PageEntryType<T> entryType;
    public final T value;

    @Nullable
    public static PageEntry<?> createPageEntry(JsonEntry entry) {
        PageEntryType<?> type;
        String typeName = entry.type;
        if (typeName == null) {
            typeName = "";
        }
        if ((type = PageEntryType.REGISTRY.get(typeName)) == null) {
            String valids = new TreeSet<String>(PageEntryType.REGISTRY.keySet()).toString();
            BCLog.logger.warn("[lib.guide] Unknown page entry type '" + typeName + "'. Valid ones are: " + valids);
            return null;
        }
        return PageEntry.createPageEntryKnown(entry, type);
    }

    @Nullable
    private static <T> PageEntry<T> createPageEntryKnown(JsonEntry entry, PageEntryType<T> type) {
        T value;
        String src = entry.source;
        if (StringUtils.func_151246_b((String)src)) {
            src = entry.itemStack;
            if (StringUtils.func_151246_b((String)src)) {
                BCLog.logger.warn("[lib.guide] Invalid page entry: must specify either 'item_stack', or 'source'!");
                return null;
            }
        } else if (!StringUtils.func_151246_b((String)entry.itemStack)) {
            BCLog.logger.warn("[lib.guide] Invalid page entry: must only specify either 'item_stack' or 'source', but not both!");
            return null;
        }
        if ((value = type.deserialise(src)) == null) {
            BCLog.logger.warn("[lib.guide] Unknown source '" + src + "'");
            return null;
        }
        String title = entry.title;
        if (title == null || title.isEmpty()) {
            List<String> tooltip = type.getTooltip(value);
            title = ColourUtil.stripAllFormatCodes(tooltip.get(0));
        }
        if (StringUtils.func_151246_b((String)entry.page)) {
            BCLog.logger.warn("[lib.guide] Invalid page entry: a page is not specified!");
            return null;
        }
        return new PageEntry<T>(title, entry.page, entry.typeTags, type, value);
    }

    private PageEntry(String title, String page, JsonTypeTags typeTags, PageEntryType<T> entryType, T value) {
        this.title = title;
        this.page = page;
        this.typeTags = typeTags;
        this.entryType = entryType;
        this.value = value;
    }

    public boolean matches(Object obj) {
        return this.entryType.matches(this.value, obj);
    }

    @Nullable
    public ISimpleDrawable createDrawable() {
        return this.entryType.createDrawable(this.value);
    }

    public Object getBasicValue() {
        return this.entryType.getBasicValue(this.value);
    }

    public String toString() {
        return "PageEntry [title=" + this.title + ", page=" + this.page + "]";
    }

    public List<String> getTooltip() {
        return this.entryType.getTooltip(this.value);
    }
}

