/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.data;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import com.google.gson.annotations.SerializedName;

public class JsonEntry {
    public final String title;
    public final String page;
    public final String type;
    public final String source;
    @SerializedName(value="item_stack")
    public final String itemStack;
    @SerializedName(value="type_tags")
    public final JsonTypeTags typeTags;

    public JsonEntry(String title, String page, String type, String source, String itemStack, JsonTypeTags typeTags) {
        this.title = title;
        this.page = page;
        this.type = type;
        this.source = source;
        this.itemStack = itemStack;
        this.typeTags = typeTags;
    }

    public JsonEntry inherit(JsonTypeTags parent, String entryMask) {
        JsonTypeTags tags = this.typeTags == null ? parent : this.typeTags.inheritMissingTags(parent);
        String realPage = this.page;
        realPage = entryMask.replaceAll("<page>", realPage);
        realPage = realPage.replaceAll("<mod>", tags.mod);
        realPage = realPage.replaceAll("<type>", tags.type);
        realPage = realPage.replaceAll("<sub_mod>", tags.subMod);
        realPage = realPage.replaceAll("<sub_type>", tags.subType);
        return new JsonEntry(this.title, realPage, this.type, this.source, this.itemStack, tags);
    }

    public void printContents() {
        BCLog.logger.info("      title = " + this.title + ",");
        BCLog.logger.info("      page = " + this.page + ",");
        BCLog.logger.info("      item_stack = " + this.itemStack + ",");
        BCLog.logger.info("      type = " + this.type + ",");
        BCLog.logger.info("      source = " + this.source + ",");
        if (this.typeTags == null) {
            BCLog.logger.info("      type_tags = null");
        } else {
            BCLog.logger.info("      type_tags = {");
            this.typeTags.printContents(4);
            BCLog.logger.info("      }");
        }
    }
}

