/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.loader;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.InvalidInputDataException;
import buildcraft.lib.client.guide.PageEntry;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.loader.IPageLoaderText;
import buildcraft.lib.client.guide.parts.GuideChapterWithin;
import buildcraft.lib.client.guide.parts.GuideImageFactory;
import buildcraft.lib.client.guide.parts.GuidePage;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.GuidePartMulti;
import buildcraft.lib.client.guide.parts.GuidePartNewPage;
import buildcraft.lib.client.guide.parts.GuidePartNote;
import buildcraft.lib.client.guide.parts.GuideText;
import buildcraft.lib.client.guide.parts.recipe.IStackRecipes;
import buildcraft.lib.client.guide.parts.recipe.RecipeLookupHelper;
import buildcraft.lib.expression.Tokenizer;
import buildcraft.lib.expression.TokenizerDefaults;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.text.TextFormatting;

public enum XmlPageLoader implements IPageLoaderText
{
    INSTANCE;

    public static final Map<String, SpecialParser> TAG_FACTORIES;
    public static final Map<String, MultiPartJoiner> GUIDE_PART_MULTIS;
    public static boolean SHOW_LORE;
    public static boolean SHOW_HINTS;
    public static boolean SHOW_DETAIL;
    public static boolean SHOW_DESCRIPTION;

    public static void putDuelMultiPartType(String name, BooleanSupplier isVisible) {
        XmlPageLoader.putSimpleMultiPartType(name, isVisible);
        XmlPageLoader.putSimpleMultiPartType("no_" + name, () -> !isVisible.getAsBoolean());
    }

    public static void putSimpleMultiPartType(String name, BooleanSupplier isVisible) {
        XmlPageLoader.putMultiPartType(name, (tag, factories) -> gui -> {
            ArrayList<GuidePart> subParts = new ArrayList<GuidePart>(factories.size());
            for (GuidePartFactory factory : factories) {
                subParts.add(factory.createNew(gui));
            }
            return new GuidePartMulti(gui, subParts, isVisible);
        });
    }

    public static void putMultiPartType(String name, MultiPartJoiner joiner) {
        GUIDE_PART_MULTIS.put(name, joiner);
    }

    public static void putSingle(String string, SpecialParserSingle parser) {
        XmlPageLoader.putMulti(string, parser);
    }

    public static void putMulti(String string, SpecialParser parser) {
        TAG_FACTORIES.put(string, parser);
    }

    @Override
    public GuidePageFactory loadPage(BufferedReader reader, PageEntry entry) throws IOException {
        String line;
        ArrayDeque nestedParts = new ArrayDeque();
        ArrayDeque<XmlTag> nestedTags = new ArrayDeque<XmlTag>();
        nestedParts.push(new ArrayList());
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("//")) continue;
            XmlTag tag = XmlPageLoader.parseTag(line);
            if (tag != null) {
                MultiPartJoiner joiner;
                if (tag.state == XmlTagState.COMPLETE) {
                    SpecialParser parser = TAG_FACTORIES.get(tag.name);
                    if (parser != null) {
                        List<GuidePartFactory> factories = parser.parse(tag);
                        if (factories != null) {
                            ((List)nestedParts.peek()).addAll(factories);
                            line = line.substring(tag.originalString.length());
                        } else {
                            int len = tag.originalString.length();
                            line = "<red>" + line.substring(0, len) + "</red>" + line.substring(len);
                        }
                    }
                } else if (tag.state == XmlTagState.START) {
                    joiner = GUIDE_PART_MULTIS.get(tag.name);
                    if (joiner != null) {
                        nestedTags.push(tag);
                        nestedParts.push(new ArrayList());
                        line = line.substring(tag.originalString.length());
                    } else {
                        int len = tag.originalString.length();
                        line = "<red>" + line.substring(0, len) + "</red>" + line.substring(len);
                    }
                } else {
                    joiner = GUIDE_PART_MULTIS.get(tag.name);
                    if (joiner != null) {
                        if (nestedTags.isEmpty()) {
                            throw new InvalidInputDataException("Tried to close " + tag.name + " before openining it!");
                        }
                        XmlTag name = (XmlTag)nestedTags.pop();
                        if (!tag.name.equals(name.name)) {
                            throw new InvalidInputDataException("Tried to close " + tag.name + " before instead of " + name.name + "!");
                        }
                        List subParts = (List)nestedParts.pop();
                        GuidePartFactory joined = joiner.join(name, subParts);
                        if (joined == null) {
                            ((List)nestedParts.peek()).addAll(subParts);
                            int len = tag.originalString.length();
                            line = "<red>" + line.substring(0, len) + "</red>" + line.substring(len);
                        } else {
                            ((List)nestedParts.peek()).add(joined);
                            line = line.substring(tag.originalString.length());
                        }
                    }
                }
                if (line.length() == 0) continue;
            }
            if (line.length() == 0) {
                line = " ";
            }
            EnumSet<TextFormatting> formattingElements = EnumSet.noneOf(TextFormatting.class);
            ArrayDeque<TextFormatting> formatColours = new ArrayDeque<TextFormatting>();
            String completeLine = "";
            int i = 0;
            while (i < line.length()) {
                TextFormatting formatting;
                XmlTag currentTag;
                char c = line.charAt(i);
                if (c == '<' && (currentTag = XmlPageLoader.parseTag(line.substring(i))) != null && (formatting = TextFormatting.func_96300_b((String)currentTag.name.replace("_", ""))) != null) {
                    if (currentTag.state == XmlTagState.END) {
                        formattingElements.remove(formatting);
                        if (formatColours.peek() == formatting) {
                            formatColours.remove();
                        }
                    } else if (currentTag.state == XmlTagState.START) {
                        if (formatting.func_96302_c()) {
                            formatColours.push(formatting);
                        } else {
                            formattingElements.add(formatting);
                        }
                    }
                    completeLine = completeLine + TextFormatting.RESET;
                    if (formatColours.peek() != null) {
                        completeLine = completeLine + formatColours.peek();
                    }
                    for (TextFormatting format : formattingElements) {
                        completeLine = completeLine + format;
                    }
                    i += currentTag.originalString.length();
                    continue;
                }
                completeLine = completeLine + c;
                ++i;
            }
            String modLine = completeLine;
            ((List)nestedParts.peek()).add(gui -> new GuideText(gui, modLine));
        }
        List factories = (List)nestedParts.pop();
        if (nestedParts.size() != 0) {
            throw new InvalidInputDataException("We haven't closed " + nestedTags);
        }
        return gui -> {
            ArrayList<GuidePart> parts = new ArrayList<GuidePart>();
            for (GuidePartFactory factory : factories) {
                parts.add(factory.createNew(gui));
            }
            String title = I18n.func_135052_a((String)entry.title, (Object[])new Object[0]);
            return new GuidePage(gui, parts, title);
        };
    }

    @Nullable
    public static XmlTag parseTag(String string) throws InvalidInputDataException {
        Object attributes;
        String tag;
        int paramStart;
        boolean hasEnd;
        if (!string.startsWith("<")) {
            return null;
        }
        int end = string.indexOf(62);
        if (end < 0) {
            throw new InvalidInputDataException("Didn't find an end tag for " + string);
        }
        String tagContents = string.substring(1, end);
        boolean hasStart = tagContents.startsWith("/");
        if (hasStart) {
            tagContents = tagContents.substring(1);
        }
        if (hasEnd = tagContents.endsWith("/")) {
            tagContents = tagContents.substring(0, tagContents.length() - 1);
        }
        if ((paramStart = tagContents.indexOf(32)) < 0) {
            tag = tagContents;
            attributes = ImmutableMap.of();
        } else {
            int index;
            tag = tagContents.substring(0, paramStart);
            attributes = new HashMap();
            String attribs = tagContents.substring(paramStart + 1);
            while (attribs.length() > 0 && (index = (attribs = attribs.trim()).indexOf(61)) >= 0) {
                String value;
                String key = attribs.substring(0, index);
                String after = attribs.substring(index + 1);
                Tokenizer.ITokenizingContext tokenCtx = Tokenizer.ITokenizingContext.createFromString(after);
                Tokenizer.TokenResult result = TokenizerDefaults.GOBBLER_QUOTE.tokenizePart(tokenCtx);
                int totalLength = index + 1;
                if (result instanceof Tokenizer.ResultConsume) {
                    value = tokenCtx.get(((Tokenizer.ResultConsume)result).length);
                    totalLength += value.length();
                    value = value.substring(1, value.length() - 1);
                } else {
                    result = TokenizerDefaults.GOBBLER_WORD.tokenizePart(tokenCtx);
                    if (result instanceof Tokenizer.ResultConsume) {
                        value = tokenCtx.get(((Tokenizer.ResultConsume)result).length);
                        totalLength += value.length();
                    } else {
                        throw new InvalidInputDataException("Not a valid tag value " + after);
                    }
                }
                attributes.put(key, value);
                attribs = attribs.substring(totalLength);
            }
        }
        XmlTagState state = hasEnd ? XmlTagState.COMPLETE : (hasStart ? XmlTagState.END : XmlTagState.START);
        return new XmlTag(tag, (Map<String, String>)attributes, state, string.substring(0, end + 1));
    }

    private static GuidePartFactory loadChapter(XmlTag tag) {
        String name = tag.get("name");
        if (name == null) {
            BCLog.logger.warn("[lib.guide.loader.xml] Found a chapter tag without a name!" + tag);
            return null;
        }
        return XmlPageLoader.chapter(name);
    }

    private static GuidePartFactory loadImage(XmlTag tag) {
        String src = tag.get("src");
        if (src == null) {
            BCLog.logger.warn("[lib.guide.loader.xml] Found an image tag without an src!" + tag);
            return null;
        }
        int width = XmlPageLoader.parseInt("width", -1, tag);
        int height = XmlPageLoader.parseInt("height", -1, tag);
        return new GuideImageFactory(src, width, height);
    }

    private static int parseInt(String name, int _default, XmlTag tag) {
        String value = tag.get(name);
        if (value == null) {
            return _default;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            BCLog.logger.warn("[lib.guide.loader.xml] Found an invalid number for image tag (" + name + ") " + tag + nfe.getMessage());
            return _default;
        }
    }

    private static GuidePartFactory loadRecipe(XmlTag tag) {
        List<GuidePartFactory> list;
        ItemStack stack = XmlPageLoader.loadItemStack(tag);
        if (stack == null) {
            return null;
        }
        String type = tag.get("type");
        if (type == null) {
            IStackRecipes recipes = RecipeLookupHelper.handlerTypes.get(type);
            if (recipes == null) {
                BCLog.logger.warn("[lib.guide.loader.xml] Unknown recipe type " + type + " - must be one of " + RecipeLookupHelper.handlerTypes.keySet());
            } else {
                List<GuidePartFactory> list2 = recipes.getRecipes(stack);
                if (list2.size() > 0) {
                    return list2.get(0);
                }
            }
        }
        if ((list = RecipeLookupHelper.getAllRecipes(stack)).isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private static List<GuidePartFactory> loadAllRecipes(XmlTag tag) {
        ItemStack stack = XmlPageLoader.loadItemStack(tag);
        if (stack == null) {
            return null;
        }
        return RecipeLookupHelper.getAllRecipes(stack);
    }

    private static List<GuidePartFactory> loadAllUsages(XmlTag tag) {
        ItemStack stack = XmlPageLoader.loadItemStack(tag);
        if (stack == null) {
            return null;
        }
        return RecipeLookupHelper.getAllUsages(stack);
    }

    private static List<GuidePartFactory> loadAllRecipesAndUsages(XmlTag tag) {
        ItemStack stack = XmlPageLoader.loadItemStack(tag);
        if (stack == null) {
            return null;
        }
        return XmlPageLoader.loadAllCrafting(stack);
    }

    public static List<GuidePartFactory> loadAllCrafting(@Nonnull ItemStack stack) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        List<GuidePartFactory> recipeParts = RecipeLookupHelper.getAllRecipes(stack);
        if (recipeParts.size() > 0) {
            list.add(GuidePartNewPage::new);
            if (recipeParts.size() == 1) {
                list.add(XmlPageLoader.chapter("buildcraft.guide.recipe.create"));
            } else {
                list.add(XmlPageLoader.chapter("buildcraft.guide.recipe.create.plural"));
            }
            list.addAll(recipeParts);
        }
        List<GuidePartFactory> usageParts = RecipeLookupHelper.getAllUsages(stack);
        usageParts.removeAll(recipeParts);
        if (usageParts.size() > 0) {
            if (recipeParts.size() != 1) {
                list.add(GuidePartNewPage::new);
            }
            if (usageParts.size() == 1) {
                list.add(XmlPageLoader.chapter("buildcraft.guide.recipe.use"));
            } else {
                list.add(XmlPageLoader.chapter("buildcraft.guide.recipe.use.plural"));
            }
            list.addAll(usageParts);
        }
        return list;
    }

    public static GuidePartFactory chapter(String after) {
        return gui -> new GuideChapterWithin(gui, I18n.func_135052_a((String)after, (Object[])new Object[0]));
    }

    public static GuidePartFactory translate(String text) {
        return gui -> new GuideText(gui, new PageLine(0, I18n.func_135052_a((String)text, (Object[])new Object[0]), false));
    }

    public static ItemStack loadItemStack(XmlTag tag) {
        String id = tag.get("stack");
        String count = tag.get("count");
        String data = tag.get("data");
        String nbt = tag.get("nbt");
        if (id == null) {
            BCLog.logger.warn("[lib.guide.loader.xml] Missing 'stack' for an itemstack from " + tag);
            return null;
        }
        ItemStack stack = null;
        Item item = Item.func_111206_d((String)id.trim());
        if (item == null) {
            BCLog.logger.warn("[lib.guide.loader.xml] " + id + " was not a valid item!");
            return null;
        }
        stack = new ItemStack(item);
        if (count != null) {
            int stackSize = 1;
            try {
                stackSize = Integer.parseInt(count.trim());
            }
            catch (NumberFormatException nfe) {
                BCLog.logger.warn("[lib.guide.loader.xml] " + count + " was not a valid number: " + nfe.getMessage());
            }
            stack.func_190920_e(stackSize);
        }
        if (data != null) {
            try {
                int meta = Integer.parseInt(data.trim());
                if (meta == -1) {
                    meta = Short.MAX_VALUE;
                }
                stack = new ItemStack(stack.func_77973_b(), stack.func_190916_E(), meta);
            }
            catch (NumberFormatException nfe) {
                BCLog.logger.warn("[lib.guide.loader.xml] " + data + " was not a valid number: " + nfe.getMessage());
            }
        }
        if (nbt != null) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)nbt));
            }
            catch (NBTException e) {
                BCLog.logger.warn("[lib.guide.loader.xml] " + nbt + " was not a valid nbt tag: " + e.getMessage());
            }
        }
        return stack;
    }

    public static GuidePartFactory loadNote(XmlTag tag, List<GuidePartFactory> factories) {
        String id = tag.get("id");
        if (id == null) {
            BCLog.logger.warn("[lib.guide.loader.xml] Found a note tag without an 'id' attribute!");
            return null;
        }
        return gui -> {
            ArrayList<GuidePart> parts = new ArrayList<GuidePart>();
            for (GuidePartFactory factory : factories) {
                parts.add(factory.createNew(gui));
            }
            return new GuidePartNote(gui, id, parts);
        };
    }

    static {
        TAG_FACTORIES = new HashMap<String, SpecialParser>();
        GUIDE_PART_MULTIS = new HashMap<String, MultiPartJoiner>();
        SHOW_LORE = true;
        SHOW_HINTS = false;
        SHOW_DETAIL = false;
        SHOW_DESCRIPTION = true;
        XmlPageLoader.putDuelMultiPartType("lore", () -> SHOW_LORE);
        XmlPageLoader.putDuelMultiPartType("description", () -> SHOW_DESCRIPTION);
        XmlPageLoader.putDuelMultiPartType("detail", () -> SHOW_DETAIL);
        XmlPageLoader.putDuelMultiPartType("hint", () -> SHOW_HINTS);
        XmlPageLoader.putMultiPartType("note", XmlPageLoader::loadNote);
        XmlPageLoader.putSingle("new_page", attr -> GuidePartNewPage::new);
        XmlPageLoader.putSingle("chapter", XmlPageLoader::loadChapter);
        XmlPageLoader.putSingle("recipe", XmlPageLoader::loadRecipe);
        XmlPageLoader.putMulti("recipes", XmlPageLoader::loadAllRecipes);
        XmlPageLoader.putMulti("usages", XmlPageLoader::loadAllUsages);
        XmlPageLoader.putMulti("recipes_usages", XmlPageLoader::loadAllRecipesAndUsages);
        XmlPageLoader.putSingle("image", XmlPageLoader::loadImage);
    }

    public static class XmlTag {
        public final String name;
        public final Map<String, String> attributes;
        public final XmlTagState state;
        public final String originalString;

        public XmlTag(String name, Map<String, String> attributes, XmlTagState state, String originalString) {
            this.name = name;
            this.attributes = attributes;
            this.state = state;
            this.originalString = originalString;
        }

        @Nullable
        public String get(String key) {
            return this.attributes.get(key);
        }

        public String toString() {
            return this.originalString;
        }
    }

    public static enum XmlTagState {
        START,
        COMPLETE,
        END;

    }

    @FunctionalInterface
    public static interface MultiPartJoiner {
        public GuidePartFactory join(XmlTag var1, List<GuidePartFactory> var2);
    }

    @FunctionalInterface
    public static interface SpecialParserSingle
    extends SpecialParser {
        @Override
        default public List<GuidePartFactory> parse(XmlTag tag) {
            GuidePartFactory single = this.parseSingle(tag);
            if (single == null) {
                return null;
            }
            return ImmutableList.of((Object)single);
        }

        public GuidePartFactory parseSingle(XmlTag var1);
    }

    @FunctionalInterface
    public static interface SpecialParser {
        public List<GuidePartFactory> parse(XmlTag var1);
    }
}

