/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.api.BCModules;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.TypeOrder;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.loader.XmlPageLoader;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuidePageBase;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.contents.ContentsNodeGui;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.client.render.font.ConfigurableFontRenderer;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.RenderUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class GuidePageContents
extends GuidePageBase {
    private static final int ORDER_OFFSET_X = -50;
    private static final int ORDER_OFFSET_Y = 14;
    private ContentsNodeGui contents;
    private final GuiTextField searchText;
    private String lastSearchText = "";
    private int realResultCount = -1;

    public GuidePageContents(GuiGuide gui) {
        super(gui);
        this.loadMainGui();
        ConfigurableFontRenderer fr = new ConfigurableFontRenderer(gui.field_146297_k.field_71466_p).disableShadow();
        this.searchText = new GuiTextField(0, (FontRenderer)fr, 0, 0, 80, fr.field_78288_b + 5);
        this.searchText.func_146185_a(false);
        this.searchText.func_146193_g(-16777216);
    }

    @Override
    public GuidePageBase createReloaded() {
        GuidePageContents newPage = new GuidePageContents(this.gui);
        newPage.searchText.func_146180_a(this.searchText.func_146179_b());
        newPage.searchText.func_146190_e(this.searchText.func_146198_h());
        newPage.searchText.func_146195_b(this.searchText.func_146206_l());
        newPage.searchText.func_146199_i(this.searchText.func_146186_n());
        newPage.numPages = this.numPages;
        newPage.goToPage(this.getIndex());
        return newPage;
    }

    public void loadMainGui() {
        this.contents = GuideManager.INSTANCE.getGuiContents(this.gui, this, this.gui.sortingOrder);
    }

    @Override
    public void setFontRenderer(IFontRenderer fontRenderer) {
        super.setFontRenderer(fontRenderer);
        this.contents.setFontRenderer(fontRenderer);
    }

    @Override
    public List<GuideChapter> getChapters() {
        return this.contents.getChapters();
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.searchText.func_146178_a();
        if (this.lastSearchText.equals(this.searchText.func_146179_b())) {
            if (this.numPages > 3 && this.getPage() > this.numPages) {
                this.goToPage(this.numPages);
            } else if (this.getPage() < 2) {
                this.searchText.func_146195_b(false);
            }
        } else {
            this.lastSearchText = this.searchText.func_146179_b();
            this.numPages = -1;
            if (this.lastSearchText.isEmpty()) {
                this.contents.node.resetVisibility();
                this.contents.invalidate();
            } else {
                String text = this.lastSearchText.toLowerCase(Locale.ROOT);
                List ret = GuideManager.INSTANCE.quickSearcher.func_194055_a(text);
                if (ret.size() > BCLibConfig.maxGuideSearchCount) {
                    this.realResultCount = ret.size();
                    ret.subList(BCLibConfig.maxGuideSearchCount, ret.size()).clear();
                } else {
                    this.realResultCount = -1;
                }
                HashSet<PageLink> matches = new HashSet<PageLink>(ret);
                this.contents.node.setVisible(matches);
                this.contents.invalidate();
                if (this.contents.node.isVisible()) {
                    this.searchText.func_146193_g(-16777216);
                } else {
                    this.searchText.func_146193_g(-65536);
                }
            }
            this.gui.refreshChapters();
        }
    }

    @Override
    protected void renderPage(int x, int y, int width, int height, int index) {
        IFontRenderer f = this.getFontRenderer();
        if (index == 0) {
            String text = "BuildCraft";
            float scale = 3.0f;
            int fWidth = (int)((float)f.getStringWidth(text) * scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)(y + height / 2 - 62) / scale), 0);
            GlStateManager.func_179121_F();
            text = "v7.99.19";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 - 36, 0);
            scale = 1.5f;
            text = LocaleUtil.localize("options.title");
            fWidth = (int)((float)f.getStringWidth(text) * scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)(y + height / 2 - 4) / scale), 0);
            GlStateManager.func_179121_F();
            text = XmlPageLoader.SHOW_LORE ? "Show Lore [x]" : "Show Lore [ ]";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 + 12, 0);
            text = XmlPageLoader.SHOW_HINTS ? "Show Hints [x]" : "Show Hints [ ]";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 + 26, 0);
        } else if (index == 1) {
            int _height = GuideManager.loadedMods.size() + 1;
            if (GuideManager.loadedOther.size() > 0) {
                ++_height;
                _height += GuideManager.loadedOther.size();
            }
            int perLineHeight = f.getFontHeight("Ly") + 3;
            int _y = y + (height - (_height *= perLineHeight)) / 2;
            this.drawCenteredText(TextFormatting.BOLD + "Loaded Mods:", x, _y, width);
            _y += perLineHeight;
            boolean first = true;
            for (String text : GuideManager.loadedMods) {
                if (first && text.contains("modules")) {
                    double mouseX = this.gui.mouse.getX();
                    double mouseY = this.gui.mouse.getY();
                    if (mouseX >= (double)(x + width / 2) && mouseX <= (double)(x + width * 7 / 8) && mouseY >= (double)_y && mouseY <= (double)(_y + perLineHeight)) {
                        this.gui.tooltip.add(LocaleUtil.localize("buildcraft.guide.contents.loaded_modules"));
                        for (BCModules module : BCModules.getLoadedModules()) {
                            this.gui.tooltip.add((GuideManager.buildCraftModules.contains(module) ? " + " : " - ") + StringUtils.capitalize((String)module.lowerCaseName));
                        }
                        if (BCModules.getMissingModules().length > 0) {
                            this.gui.tooltip.add(LocaleUtil.localize("buildcraft.guide.contents.missing_modules"));
                            for (BCModules module : BCModules.getMissingModules()) {
                                this.gui.tooltip.add(" - " + StringUtils.capitalize((String)module.lowerCaseName));
                            }
                        }
                    }
                }
                this.drawCenteredText(text, x, _y, width);
                _y += perLineHeight;
                first = false;
            }
            if (GuideManager.loadedOther.size() > 0) {
                this.drawCenteredText(TextFormatting.BOLD + "Loaded Resource Packs:", x, _y, width);
                _y += perLineHeight;
                for (String text : GuideManager.loadedOther) {
                    this.drawCenteredText(text, x, _y, width);
                    _y += perLineHeight;
                }
            }
        } else if (index % 2 == 0) {
            this.searchText.field_146209_f = x + 23;
            this.searchText.field_146210_g = y - 23;
            if (!this.searchText.func_146206_l() && this.searchText.func_146179_b().isEmpty()) {
                GuiGuide.SEARCH_TAB_CLOSED.drawAt(x + 8, y - 20);
                GuiGuide.SEARCH_ICON.drawAt(x + 8, y - 19);
            } else {
                GuiGuide.SEARCH_TAB_OPEN.drawAt(x - 2, y - 29);
                GuiGuide.SEARCH_ICON.drawAt(x + 8, y - 25);
            }
            this.searchText.func_146194_f();
            if (this.realResultCount >= 0) {
                String text = LocaleUtil.localize("buildcraft.guide.too_many_results", this.realResultCount);
                this.getFontRenderer().drawString(text, x + 105, y - 23, -1);
            }
        }
        RenderUtil.setGLColorFromInt(-1);
        GuidePart.PagePosition pos = new GuidePart.PagePosition(2, 0);
        pos = this.contents.render(x, y, width, height, pos, index);
        if (this.numPages == -1) {
            this.numPages = pos.page + 1;
        }
        super.renderPage(x, y, width, height, index);
        if (index % 2 == 0) {
            int oX = x + -50;
            int oY = y + 14;
            int i = 0;
            for (int j = 0; j < GuiGuide.ORDERS.length; ++j) {
                GuiIcon icon = GuiGuide.ORDERS[j];
                if (this.gui.sortingOrder == GuiGuide.SORTING_TYPES[j]) {
                    icon = icon.offset(0.0, 14.0);
                }
                icon.drawAt(oX, oY);
                oY += 14;
                ++i;
            }
        }
    }

    private void drawCenteredText(String text, int x, int y, int width) {
        IFontRenderer f = this.getFontRenderer();
        int fWidth = f.getStringWidth(text);
        f.drawString(text, x + (width - fWidth) / 2, y, 0);
    }

    private void drawScaledCenteredText(float scale, String text, int x, int y, int width) {
        IFontRenderer f = this.getFontRenderer();
        int fWidth = (int)((float)f.getStringWidth(text) * scale);
        if (scale != 1.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        }
        f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)y / scale), 0);
        if (scale != 1.0f) {
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void handleMouseClick(int x, int y, int width, int height, int mouseX, int mouseY, int mouseButton, int index, boolean isEditing) {
        super.handleMouseClick(x, y, width, height, mouseX, mouseY, mouseButton, index, isEditing);
        if (index % 2 == 0) {
            int oX = x + -50;
            int oY = y + 14;
            for (TypeOrder order : GuiGuide.SORTING_TYPES) {
                GuiRectangle rect = new GuiRectangle(oX, oY, 14.0, 14.0);
                if (rect.contains(this.gui.mouse)) {
                    this.gui.sortingOrder = order;
                    this.loadMainGui();
                    this.gui.refreshChapters();
                    this.contents.setFontRenderer(this.getFontRenderer());
                    return;
                }
                oY += 14;
            }
            if (!this.searchText.func_146192_a(mouseX, mouseY, mouseButton) && !this.searchText.func_146206_l() && new GuiRectangle(x - 2, y - 34, 40.0, 34.0).contains(mouseX, mouseY)) {
                this.searchText.func_146195_b(true);
            }
            if (mouseButton == 1 && mouseX >= this.searchText.field_146209_f && mouseX < this.searchText.field_146209_f + this.searchText.field_146218_h && mouseY >= this.searchText.field_146210_g && mouseY < this.searchText.field_146210_g + this.searchText.field_146219_i) {
                this.searchText.func_146180_a("");
            }
        }
        if (mouseButton == 0 && index == 0) {
            String text;
            IFontRenderer f = this.getFontRenderer();
            int fWidth = f.getStringWidth(text = XmlPageLoader.SHOW_LORE ? "Show Lore [x]" : "Show Lore [ ]");
            GuiRectangle rect = new GuiRectangle(x + (width - fWidth) / 2, y + height / 2 + 12, fWidth, f.getFontHeight(text));
            if (rect.contains(mouseX, mouseY)) {
                XmlPageLoader.SHOW_LORE = !XmlPageLoader.SHOW_LORE;
            }
            if ((rect = new GuiRectangle(x + (width - (fWidth = f.getStringWidth(text = XmlPageLoader.SHOW_HINTS ? "Show Hints [x]" : "Show Hints [ ]"))) / 2, y + height / 2 + 26, fWidth, f.getFontHeight(text))).contains(mouseX, mouseY)) {
                boolean bl = XmlPageLoader.SHOW_HINTS = !XmlPageLoader.SHOW_HINTS;
            }
        }
        if (new GuiRectangle(x, y, width, height).contains(mouseX, mouseY)) {
            this.contents.onClicked(x, y, width, height, new GuidePart.PagePosition(2, 0), index);
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return this.searchText.func_146201_a(typedChar, keyCode);
    }
}

