/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.api.statements.IStatement;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.parts.GuidePage;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.statement.GuiElementStatementSource;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.util.text.TextFormatting;

public class PageLinkStatement
extends PageLink {
    public final IStatement statement;
    public final List<String> tooltip;
    public final String searchText;

    public PageLinkStatement(boolean startVisible, IStatement statement) {
        super(PageLinkStatement.createPageLine(statement), startVisible);
        this.statement = statement;
        List<String> tip = statement.getTooltip();
        if (tip.isEmpty()) {
            String uniqueTag = statement.getUniqueTag();
            this.tooltip = ImmutableList.of((Object)uniqueTag);
            this.searchText = uniqueTag.toLowerCase(Locale.ROOT);
        } else {
            this.tooltip = tip;
            String joinedTooltip = tip.stream().collect(Collectors.joining(" ", "", ""));
            this.searchText = TextFormatting.func_110646_a((String)joinedTooltip).toLowerCase(Locale.ROOT);
        }
    }

    private static PageLine createPageLine(IStatement statement) {
        ISimpleDrawable icon = (x, y) -> GuiElementStatementSource.drawGuiSlot(statement, x, y);
        List<String> tooltip = statement.getTooltip();
        String title = tooltip.isEmpty() ? statement.getUniqueTag() : tooltip.get(0);
        return new PageLine(icon, icon, 2, title, true);
    }

    @Override
    public String getSearchName() {
        return this.searchText;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip.size() == 1 ? null : this.tooltip;
    }

    @Override
    public GuidePageFactory getFactoryLink() {
        return g -> new GuidePage(g, (List<GuidePart>)ImmutableList.of(), this.tooltip.get(0));
    }
}

