/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.laser;

import buildcraft.lib.client.render.laser.ILaserRenderer;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class LaserCompiledList {
    public abstract void render();

    public abstract void delete();

    private static class Vbo
    extends LaserCompiledList {
        private final boolean useColour;
        private final VertexBuffer vertexBuffer;

        private Vbo(boolean useColour, VertexBuffer vertexBuffer) {
            this.useColour = useColour;
            this.vertexBuffer = vertexBuffer;
        }

        @Override
        public void render() {
            int stride = this.useColour ? 28 : 24;
            this.vertexBuffer.func_177359_a();
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187420_d((int)3, (int)5126, (int)stride, (int)0);
            GlStateManager.func_187410_q((int)32888);
            GlStateManager.func_187405_c((int)2, (int)5126, (int)stride, (int)12);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187410_q((int)32888);
            GlStateManager.func_187405_c((int)2, (int)5122, (int)stride, (int)20);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            if (this.useColour) {
                GlStateManager.func_187410_q((int)32886);
                GlStateManager.func_187406_e((int)4, (int)5121, (int)stride, (int)24);
            }
            this.vertexBuffer.func_177358_a(7);
            this.vertexBuffer.func_177361_b();
            GlStateManager.func_187429_p((int)32884);
            GlStateManager.func_187429_p((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187429_p((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            if (this.useColour) {
                GlStateManager.func_187429_p((int)32886);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        @Override
        public void delete() {
            this.vertexBuffer.func_177362_c();
        }
    }

    private static class GlList
    extends LaserCompiledList {
        private final int glListId;

        private GlList(int glListId) {
            this.glListId = glListId;
        }

        @Override
        public void render() {
            GL11.glCallList((int)this.glListId);
        }

        @Override
        public void delete() {
            GL11.glDeleteLists((int)this.glListId, (int)1);
        }
    }

    public static class Builder
    implements ILaserRenderer {
        private final boolean useColour;

        public Builder(boolean useNormalColour) {
            this.useColour = useNormalColour;
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            bufferBuilder.func_181668_a(7, useNormalColour ? LaserRenderer_BC8.FORMAT_ALL : LaserRenderer_BC8.FORMAT_LESS);
        }

        @Override
        public void vertex(double x, double y, double z, double u, double v, int lmap, float nx, float ny, float nz, float diffuse) {
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            bufferBuilder.func_181662_b(x, y, z);
            bufferBuilder.func_187315_a(u, v);
            bufferBuilder.func_187314_a(lmap >> 16 & 0xFFFF, lmap & 0xFFFF);
            if (this.useColour) {
                bufferBuilder.func_181666_a(diffuse, diffuse, diffuse, 1.0f);
            }
            bufferBuilder.func_181675_d();
        }

        public LaserCompiledList build() {
            if (OpenGlHelper.func_176075_f()) {
                BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
                VertexBuffer vertexBuffer = new VertexBuffer(bufferBuilder.func_178973_g());
                bufferBuilder.func_178977_d();
                bufferBuilder.func_178965_a();
                vertexBuffer.func_181722_a(bufferBuilder.func_178966_f());
                return new Vbo(this.useColour, vertexBuffer);
            }
            int glList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)glList, (int)4864);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glEndList();
            return new GlList(glList);
        }
    }
}

