/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantObject;

public class NodeFuncDoubleDoubleToObject<R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncDoubleDoubleToObject<R> function;
    private final StringFunctionTri stringFunction;
    private final Class<R> returnType;

    public NodeFuncDoubleDoubleToObject(String name, Class<R> returnType, IFuncDoubleDoubleToObject<R> function) {
        this(returnType, function, (String a, String b) -> "[ double, double -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncDoubleDoubleToObject(Class<R> returnType, IFuncDoubleDoubleToObject<R> function, StringFunctionTri stringFunction) {
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble b = stack.popDouble();
        IExpressionNode.INodeDouble a = stack.popDouble();
        return new Func(a, b);
    }

    @FunctionalInterface
    public static interface IFuncDoubleDoubleToObject<R> {
        public R apply(double var1, double var3);
    }

    private class Func
    implements IExpressionNode.INodeObject<R> {
        private final IExpressionNode.INodeDouble argA;
        private final IExpressionNode.INodeDouble argB;

        public Func(IExpressionNode.INodeDouble argA, IExpressionNode.INodeDouble argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncDoubleDoubleToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncDoubleDoubleToObject.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncDoubleDoubleToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b), (a, b) -> new Func((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b), (a, b) -> new NodeConstantObject(NodeFuncDoubleDoubleToObject.this.returnType, NodeFuncDoubleDoubleToObject.this.function.apply(a.evaluate(), b.evaluate())));
        }

        public String toString() {
            return NodeFuncDoubleDoubleToObject.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }
    }
}

