/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantObject;

public class NodeFuncDoubleToObject<R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncDoubleToObject<R> function;
    private final StringFunctionBi stringFunction;
    private final Class<R> returnType;

    public NodeFuncDoubleToObject(String name, Class<R> returnType, IFuncDoubleToObject<R> function) {
        this(returnType, function, (String a) -> "[ double -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ")");
    }

    public NodeFuncDoubleToObject(Class<R> returnType, IFuncDoubleToObject<R> function, StringFunctionBi stringFunction) {
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble a = stack.popDouble();
        return new Func(a);
    }

    @FunctionalInterface
    public static interface IFuncDoubleToObject<R> {
        public R apply(double var1);
    }

    private class Func
    implements IExpressionNode.INodeObject<R> {
        private final IExpressionNode.INodeDouble argA;

        public Func(IExpressionNode.INodeDouble argA) {
            this.argA = argA;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncDoubleToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncDoubleToObject.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncDoubleToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new Func((IExpressionNode.INodeDouble)a), a -> new Func((IExpressionNode.INodeDouble)a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new Func((IExpressionNode.INodeDouble)a), a -> new NodeConstantObject(NodeFuncDoubleToObject.this.returnType, NodeFuncDoubleToObject.this.function.apply(a.evaluate())));
        }

        public String toString() {
            return NodeFuncDoubleToObject.this.stringFunction.apply(this.argA.toString());
        }
    }
}

