/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;

public class NodeFuncObjectObjectToBoolean<A, B>
extends NodeFuncBase
implements INodeFunc.INodeFuncBoolean {
    public final IFuncObjectObjectToBoolean<A, B> function;
    private final StringFunctionTri stringFunction;
    private final Class<A> argTypeA;
    private final Class<B> argTypeB;

    public NodeFuncObjectObjectToBoolean(String name, Class<A> argTypeA, Class<B> argTypeB, IFuncObjectObjectToBoolean<A, B> function) {
        this(argTypeA, argTypeB, function, (String a, String b) -> "[ " + NodeTypes.getName(argTypeA) + ", " + NodeTypes.getName(argTypeB) + " -> boolean ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncObjectObjectToBoolean(Class<A> argTypeA, Class<B> argTypeB, IFuncObjectObjectToBoolean<A, B> function, StringFunctionTri stringFunction) {
        this.argTypeA = argTypeA;
        this.argTypeB = argTypeB;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public IExpressionNode.INodeBoolean getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeObject<B> b = stack.popObject(this.argTypeB);
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return new Func(a, b);
    }

    @FunctionalInterface
    public static interface IFuncObjectObjectToBoolean<A, B> {
        public boolean apply(A var1, B var2);
    }

    private class Func
    implements IExpressionNode.INodeBoolean {
        private final IExpressionNode.INodeObject<A> argA;
        private final IExpressionNode.INodeObject<B> argB;

        public Func(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeObject<B> argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public boolean evaluate() {
            return NodeFuncObjectObjectToBoolean.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeBoolean inline() {
            if (!NodeFuncObjectObjectToBoolean.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func(a, b), (a, b) -> new Func(a, b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func(a, b), (a, b) -> NodeConstantBoolean.of(NodeFuncObjectObjectToBoolean.this.function.apply(a.evaluate(), b.evaluate())));
        }

        public String toString() {
            return NodeFuncObjectObjectToBoolean.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }
    }
}

