/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;

public class NodeFuncObjectToBoolean<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncBoolean {
    public final IFuncObjectToBoolean<A> function;
    private final StringFunctionBi stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectToBoolean(String name, Class<A> argTypeA, IFuncObjectToBoolean<A> function) {
        this(argTypeA, function, (String a) -> "[ " + NodeTypes.getName(argTypeA) + " -> boolean ] " + name + "(" + a + ")");
    }

    public NodeFuncObjectToBoolean(Class<A> argTypeA, IFuncObjectToBoolean<A> function, StringFunctionBi stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public IExpressionNode.INodeBoolean getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return new Func(a);
    }

    @FunctionalInterface
    public static interface IFuncObjectToBoolean<A> {
        public boolean apply(A var1);
    }

    private class Func
    implements IExpressionNode.INodeBoolean {
        private final IExpressionNode.INodeObject<A> argA;

        public Func(IExpressionNode.INodeObject<A> argA) {
            this.argA = argA;
        }

        @Override
        public boolean evaluate() {
            return NodeFuncObjectToBoolean.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeBoolean inline() {
            if (!NodeFuncObjectToBoolean.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new Func(a), a -> new Func(a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new Func(a), a -> NodeConstantBoolean.of(NodeFuncObjectToBoolean.this.function.apply(a.evaluate())));
        }

        public String toString() {
            return NodeFuncObjectToBoolean.this.stringFunction.apply(this.argA.toString());
        }
    }
}

