/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.value;

import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import buildcraft.lib.expression.node.value.NodeVariable;

public class NodeVariableObject<T>
extends NodeVariable
implements IVariableNode.IVariableNodeObject<T> {
    public final Class<T> type;
    public T value;

    public NodeVariableObject(String name, Class<T> type) {
        super(name);
        this.type = type;
        NodeType<T> nodeType = NodeTypes.getType(type);
        if (nodeType == null) {
            throw new IllegalArgumentException("Unknown NodeType " + type);
        }
        this.value = nodeType.defaultValue;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T evaluate() {
        return this.value;
    }

    @Override
    public IExpressionNode.INodeObject<T> inline() {
        if (this.isConst) {
            return new NodeConstantObject<T>(this.getType(), this.value);
        }
        return this;
    }

    @Override
    public void set(T value) {
        this.value = value;
    }
}

