/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.expression.node.value.NodeConstantObject;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.RenderUtil;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuiElementText
extends GuiElementSimple {
    public boolean dropShadow = false;
    public boolean foreground = false;
    public boolean centered = false;
    private final Supplier<String> text;
    private final IntSupplier colour;

    public GuiElementText(BuildCraftGui gui, IGuiPosition parent, Supplier<String> text, IntSupplier colour) {
        super(gui, GuiRectangle.ZERO.offset(parent));
        this.text = text;
        this.colour = colour;
    }

    public GuiElementText(BuildCraftGui gui, IGuiPosition parent, Supplier<String> text, int colour) {
        this(gui, parent, text, () -> colour);
    }

    public GuiElementText(BuildCraftGui gui, IGuiPosition parent, String text, int colour) {
        this(gui, parent, new NodeConstantObject<String>(String.class, text), () -> colour);
    }

    public GuiElementText setDropShadow(boolean value) {
        this.dropShadow = value;
        return this;
    }

    public GuiElementText setForeground(boolean value) {
        this.foreground = value;
        return this;
    }

    public GuiElementText setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    @Override
    public double getWidth() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        return fr.func_78256_a(this.text.get());
    }

    @Override
    public double getHeight() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        return fr.field_78288_b;
    }

    @Override
    public void drawBackground(float partialTicks) {
        if (!this.foreground) {
            this.draw();
        }
    }

    @Override
    public void drawForeground(float partialTicks) {
        if (this.foreground) {
            this.draw();
        }
    }

    private void draw() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        if (this.centered) {
            String str = this.text.get();
            int width = fr.func_78256_a(str);
            double x = this.getX() - (double)(width / 2);
            fr.func_175065_a(str, (float)x, (float)this.getY(), this.colour.getAsInt(), this.dropShadow);
        } else {
            fr.func_175065_a(this.text.get(), (float)this.getX(), (float)this.getY(), this.colour.getAsInt(), this.dropShadow);
        }
        RenderUtil.setGLColorFromInt(-1);
    }

    @Override
    public String getDebugInfo(List<String> info) {
        info.add("text = " + this.text);
        return super.getDebugInfo(info);
    }
}

