/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.mj.MjAPI;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.compat.CompatManager;
import buildcraft.lib.inventory.TransactorEntityItem;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.world.SingleBlockAccess;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class BlockUtil {
    @Nullable
    public static NonNullList<ItemStack> getItemStackFromBlock(WorldServer world, BlockPos pos, GameProfile owner) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return null;
        }
        List drops = block.getDrops((IBlockAccess)world, pos, state, 0);
        FakePlayer fakePlayer = BuildCraftAPI.fakePlayerProvider.getFakePlayer(world, owner, pos);
        float dropChance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
        NonNullList returnList = NonNullList.func_191196_a();
        for (ItemStack s : drops) {
            if (!(world.field_73012_v.nextFloat() <= dropChance)) continue;
            returnList.add((Object)s);
        }
        return returnList;
    }

    public static boolean breakBlock(WorldServer world, BlockPos pos, BlockPos ownerPos, GameProfile owner) {
        return BlockUtil.breakBlock(world, pos, BCLibConfig.itemLifespan * 20, ownerPos, owner);
    }

    public static boolean breakBlock(WorldServer world, BlockPos pos, int forcedLifespan, BlockPos ownerPos, GameProfile owner) {
        NonNullList items = NonNullList.func_191196_a();
        if (BlockUtil.breakBlock(world, pos, (NonNullList<ItemStack>)items, ownerPos, owner)) {
            for (ItemStack item : items) {
                BlockUtil.dropItem(world, pos, forcedLifespan, item);
            }
            return true;
        }
        return false;
    }

    public static boolean harvestBlock(WorldServer world, BlockPos pos, @Nonnull ItemStack tool, GameProfile owner) {
        FakePlayer fakePlayer = BlockUtil.getFakePlayerWithTool(world, tool, owner);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((World)world, pos, world.func_180495_p(pos), (EntityPlayer)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)fakePlayer)) {
            return false;
        }
        state.func_177230_c().func_176208_a((World)world, pos, state, (EntityPlayer)fakePlayer);
        state.func_177230_c().func_180657_a((World)world, (EntityPlayer)fakePlayer, pos, state, world.func_175625_s(pos), tool);
        world.func_175655_b(pos, false);
        return true;
    }

    public static boolean destroyBlock(WorldServer world, BlockPos pos, @Nonnull ItemStack tool, GameProfile owner) {
        FakePlayer fakePlayer = BlockUtil.getFakePlayerWithTool(world, tool, owner);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((World)world, pos, world.func_180495_p(pos), (EntityPlayer)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        world.func_175655_b(pos, true);
        return true;
    }

    public static FakePlayer getFakePlayerWithTool(WorldServer world, @Nonnull ItemStack tool, GameProfile owner) {
        FakePlayer player = BuildCraftAPI.fakePlayerProvider.getFakePlayer(world, owner);
        for (int i = 0; player.func_184614_ca() != tool && i < 9; ++i) {
            if (i > 0) {
                player.field_71071_by.func_70299_a(i - 1, StackUtil.EMPTY);
            }
            player.field_71071_by.func_70299_a(i, tool);
        }
        return player;
    }

    public static boolean breakBlock(WorldServer world, BlockPos pos, NonNullList<ItemStack> drops, BlockPos ownerPos, GameProfile owner) {
        FakePlayer fakePlayer = BuildCraftAPI.fakePlayerProvider.getFakePlayer(world, owner, ownerPos);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((World)world, pos, world.func_180495_p(pos), (EntityPlayer)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        if (!world.func_175623_d(pos) && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            drops.addAll(BlockUtil.getItemStackFromBlock(world, pos, owner));
        }
        world.func_175698_g(pos);
        return true;
    }

    public static void dropItem(WorldServer world, BlockPos pos, int forcedLifespan, ItemStack stack) {
        float var = 0.7f;
        double dx = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dy = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dz = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        EntityItem entityitem = new EntityItem((World)world, (double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy, (double)pos.func_177952_p() + dz, stack);
        entityitem.lifespan = forcedLifespan;
        entityitem.func_174869_p();
        world.func_72838_d((Entity)entityitem);
    }

    public static Optional<List<ItemStack>> breakBlockAndGetDrops(WorldServer world, BlockPos pos, @Nonnull ItemStack tool, GameProfile owner) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_186662_g(1.0);
        HashSet entities = new HashSet(world.func_72872_a(EntityItem.class, aabb));
        if (!BlockUtil.harvestBlock(world, pos, tool, owner) && !BlockUtil.destroyBlock(world, pos, tool, owner)) {
            return Optional.empty();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EntityItem entity : world.func_72872_a(EntityItem.class, aabb)) {
            ItemStack stack;
            if (entities.contains(entity)) continue;
            TransactorEntityItem transactor = new TransactorEntityItem(entity);
            while (!(stack = transactor.extract(StackFilter.ALL, 0, Integer.MAX_VALUE, false)).func_190926_b()) {
                stacks.add(stack);
            }
        }
        return Optional.of(stacks);
    }

    public static boolean canChangeBlock(World world, BlockPos pos, GameProfile owner) {
        return BlockUtil.canChangeBlock(world.func_180495_p(pos), world, pos, owner);
    }

    public static boolean canChangeBlock(IBlockState state, World world, BlockPos pos, GameProfile owner) {
        Fluid f;
        if (state == null) {
            return true;
        }
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return true;
        }
        if (BlockUtil.isUnbreakableBlock(world, pos, state, owner)) {
            return false;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return false;
        }
        return !(block instanceof IFluidBlock) || ((IFluidBlock)block).getFluid() == null || (f = ((IFluidBlock)block).getFluid()).getDensity(world, pos) < 3000;
    }

    public static float getBlockHardnessMining(World world, BlockPos pos, IBlockState state, GameProfile owner) {
        FakePlayer fakePlayer;
        float relativeHardness;
        if (world instanceof WorldServer && (relativeHardness = state.func_185903_a((EntityPlayer)(fakePlayer = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)world, owner)), world, pos)) <= 0.0f) {
            return -1.0f;
        }
        return state.func_185887_b(world, pos);
    }

    public static boolean isUnbreakableBlock(World world, BlockPos pos, IBlockState state, GameProfile owner) {
        return BlockUtil.getBlockHardnessMining(world, pos, state, owner) < 0.0f;
    }

    public static boolean isUnbreakableBlock(World world, BlockPos pos, GameProfile owner) {
        return BlockUtil.isUnbreakableBlock(world, pos, world.func_180495_p(pos), owner);
    }

    public static boolean isToughBlock(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185904_a().func_76229_l();
    }

    public static boolean isFullFluidBlock(World world, BlockPos pos) {
        return BlockUtil.isFullFluidBlock(world.func_180495_p(pos), world, pos);
    }

    public static boolean isFullFluidBlock(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            FluidStack fluid = ((IFluidBlock)block).drain(world, pos, false);
            return fluid == null || fluid.amount > 0;
        }
        if (block instanceof BlockLiquid) {
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            return level == 0;
        }
        return false;
    }

    public static Fluid getFluid(World world, BlockPos pos) {
        FluidStack fluid = BlockUtil.drainBlock(world, pos, false);
        return fluid != null ? fluid.getFluid() : null;
    }

    public static Fluid getFluidWithFlowing(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150358_i) {
            return FluidRegistry.WATER;
        }
        if (block == Blocks.field_150356_k) {
            return FluidRegistry.LAVA;
        }
        return BlockUtil.getFluid(block);
    }

    public static Fluid getFluid(Block block) {
        if (block instanceof IFluidBlock) {
            return FluidRegistry.getFluid((String)((IFluidBlock)block).getFluid().getName());
        }
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static Fluid getFluidWithoutFlowing(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockFluidClassic && ((BlockFluidClassic)block).isSourceBlock((IBlockAccess)new SingleBlockAccess(state), SingleBlockAccess.POS)) {
            return BlockUtil.getFluid(block);
        }
        if (block instanceof BlockLiquid) {
            if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                return null;
            }
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                return FluidRegistry.WATER;
            }
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                return FluidRegistry.LAVA;
            }
            return FluidRegistry.lookupFluidForBlock((Block)block);
        }
        return null;
    }

    public static Fluid getFluidWithFlowing(Block block) {
        Fluid fluid = null;
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            fluid = FluidRegistry.LAVA;
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            fluid = FluidRegistry.WATER;
        } else if (block instanceof BlockFluidBase) {
            fluid = ((BlockFluidBase)block).getFluid();
        }
        return fluid;
    }

    public static FluidStack drainBlock(World world, BlockPos pos, boolean doDrain) {
        IFluidHandler handler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, null);
        if (handler != null) {
            return handler.drain(1000, doDrain);
        }
        return null;
    }

    public static void explodeBlock(World world, BlockPos pos) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        Explosion explosion = new Explosion(world, null, x, y, z, 3.0f, false, false);
        explosion.func_180343_e().add(pos);
        explosion.func_77279_a(true);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP) || !(player.func_174818_b(pos) < 4096.0)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketExplosion(x, y, z, 3.0f, explosion.func_180343_e(), null));
        }
    }

    public static long computeBlockBreakPower(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        return (long)Math.floor((double)((float)(16L * MjAPI.MJ) * ((hardness + 1.0f) * 2.0f)) * BCCoreConfig.miningMultiplier);
    }

    public static TileEntity getTileEntity(World world, BlockPos pos) {
        return BlockUtil.getTileEntity(world, pos, false);
    }

    public static TileEntity getTileEntity(World world, BlockPos pos, boolean force) {
        return CompatManager.getTile(world, pos, force);
    }

    public static IBlockState getBlockState(World world, BlockPos pos) {
        return BlockUtil.getBlockState(world, pos, false);
    }

    public static IBlockState getBlockState(World world, BlockPos pos, boolean force) {
        return CompatManager.getState(world, pos, force);
    }

    public static boolean useItemOnBlock(World world, EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing direction) {
        boolean done;
        boolean bl = done = stack.func_77973_b().onItemUseFirst(player, world, pos, direction, 0.5f, 0.5f, 0.5f, EnumHand.MAIN_HAND) == EnumActionResult.SUCCESS;
        if (!done) {
            done = stack.func_77973_b().func_180614_a(player, world, pos, EnumHand.MAIN_HAND, direction, 0.5f, 0.5f, 0.5f) == EnumActionResult.SUCCESS;
        }
        return done;
    }

    public static void onComparatorUpdate(World world, BlockPos pos, Block block) {
        world.func_175666_e(pos, block);
    }

    public static TileEntityChest getOtherDoubleChest(TileEntity inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest adjacent = null;
            chest.func_145979_i();
            if (chest.field_145991_k != null) {
                adjacent = chest.field_145991_k;
            }
            if (chest.field_145990_j != null) {
                adjacent = chest.field_145990_j;
            }
            if (chest.field_145992_i != null) {
                adjacent = chest.field_145992_i;
            }
            if (chest.field_145988_l != null) {
                adjacent = chest.field_145988_l;
            }
            return adjacent;
        }
        return null;
    }

    public static <T extends Comparable<T>> IBlockState copyProperty(IProperty<T> property, IBlockState dst, IBlockState src) {
        return dst.func_177227_a().contains(property) ? dst.func_177226_a(property, src.func_177229_b(property)) : dst;
    }

    public static <T extends Comparable<T>> int compareProperty(IProperty<T> property, IBlockState a, IBlockState b) {
        return a.func_177229_b(property).compareTo(b.func_177229_b(property));
    }

    public static <T extends Comparable<T>> String getPropertyStringValue(IBlockState blockState, IProperty<T> property) {
        return property.func_177702_a(blockState.func_177229_b(property));
    }

    public static Map<String, String> getPropertiesStringMap(IBlockState blockState, Collection<IProperty<?>> properties) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (IProperty<?> property : properties) {
            mapBuilder.put((Object)property.func_177701_a(), (Object)BlockUtil.getPropertyStringValue(blockState, property));
        }
        return mapBuilder.build();
    }

    public static Map<String, String> getPropertiesStringMap(IBlockState blockState) {
        return BlockUtil.getPropertiesStringMap(blockState, blockState.func_177227_a());
    }

    public static Comparator<IBlockState> blockStateComparator() {
        return (blockStateA, blockStateB) -> {
            Block blockB;
            Block blockA = blockStateA.func_177230_c();
            if (blockA != (blockB = blockStateB.func_177230_c())) {
                return blockA.getRegistryName().toString().compareTo(blockB.getRegistryName().toString());
            }
            for (IProperty property : Sets.intersection(new HashSet(blockStateA.func_177227_a()), new HashSet(blockStateB.func_177227_a()))) {
                int compareResult = BlockUtil.compareProperty(property, blockStateA, blockStateB);
                if (compareResult == 0) continue;
                return compareResult;
            }
            return 0;
        };
    }

    public static boolean blockStatesWithoutBlockEqual(IBlockState a, IBlockState b, Collection<IProperty<?>> ignoredProperties) {
        return Sets.intersection(new HashSet(a.func_177227_a()), new HashSet(b.func_177227_a())).stream().filter(property -> !ignoredProperties.contains(property)).allMatch(property -> Objects.equals(a.func_177229_b(property), b.func_177229_b(property)));
    }

    public static boolean blockStatesWithoutBlockEqual(IBlockState a, IBlockState b) {
        return Sets.intersection(new HashSet(a.func_177227_a()), new HashSet(b.func_177227_a())).stream().allMatch(property -> Objects.equals(a.func_177229_b(property), b.func_177229_b(property)));
    }

    public static boolean blockStatesEqual(IBlockState a, IBlockState b, Collection<IProperty<?>> ignoredProperties) {
        return a.func_177230_c() == b.func_177230_c() && Sets.intersection(new HashSet(a.func_177227_a()), new HashSet(b.func_177227_a())).stream().filter(property -> !ignoredProperties.contains(property)).allMatch(property -> Objects.equals(a.func_177229_b(property), b.func_177229_b(property)));
    }

    public static boolean blockStatesEqual(IBlockState a, IBlockState b) {
        return a.func_177230_c() == b.func_177230_c() && Sets.intersection(new HashSet(a.func_177227_a()), new HashSet(b.func_177227_a())).stream().allMatch(property -> Objects.equals(a.func_177229_b(property), b.func_177229_b(property)));
    }

    public static Comparator<BlockPos> uniqueBlockPosComparator(Comparator<BlockPos> parent) {
        return (a, b) -> {
            int parentValue = parent.compare((BlockPos)a, (BlockPos)b);
            if (parentValue != 0) {
                return parentValue;
            }
            if (a.func_177958_n() != b.func_177958_n()) {
                return Integer.compare(a.func_177958_n(), b.func_177958_n());
            }
            if (a.func_177956_o() != b.func_177956_o()) {
                return Integer.compare(a.func_177956_o(), b.func_177956_o());
            }
            if (a.func_177952_p() != b.func_177952_p()) {
                return Integer.compare(a.func_177952_p(), b.func_177952_p());
            }
            return 0;
        };
    }
}

