/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.minecraft.profiler.Profiler;

public class ProfilerUtil {
    public static void printProfilerResults(Profiler profiler, String rootName) {
        ProfilerUtil.writeProfilerResults(profiler, rootName, System.out::println);
    }

    public static void saveProfilerResults(Profiler profiler, String rootName, File dest) throws IOException {
        dest = dest.getAbsoluteFile();
        dest.getParentFile().mkdirs();
        ProfilerUtil.saveProfilerResults(profiler, rootName, dest.toPath());
    }

    public static void saveProfilerResults(Profiler profiler, String rootName, Path dest) throws IOException {
        try (BufferedWriter br = Files.newBufferedWriter(dest, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            ProfilerUtil.writeProfilerResults(profiler, rootName, str -> {
                br.write(str);
                br.newLine();
            });
            br.flush();
        }
    }

    public static <E extends Throwable> void writeProfilerResults(Profiler profiler, String rootName, ILogAcceptor<E> dest) throws E {
        ProfilerUtil.writeProfilerResults_Internal(profiler, rootName, 0, dest);
    }

    private static <E extends Throwable> void writeProfilerResults_Internal(Profiler profiler, String sectionName, int indent, ILogAcceptor<E> dest) throws E {
        List list = profiler.func_76321_b(sectionName);
        if (list != null && list.size() >= 3) {
            for (int i = 1; i < list.size(); ++i) {
                Profiler.Result profiler$result = (Profiler.Result)list.get(i);
                StringBuilder builder = new StringBuilder();
                builder.append(String.format("[%02d] ", indent));
                for (int j = 0; j < indent; ++j) {
                    builder.append("|   ");
                }
                builder.append(profiler$result.field_76331_c);
                builder.append(" - ");
                builder.append(String.format("%.2f", profiler$result.field_76332_a));
                builder.append("%/");
                builder.append(String.format("%.2f", profiler$result.field_76330_b));
                dest.write(builder.toString());
                if ("unspecified".equals(profiler$result.field_76331_c)) continue;
                if (indent > 20) {
                    dest.write("[[ Too deep! ]]");
                    continue;
                }
                ProfilerUtil.writeProfilerResults_Internal(profiler, sectionName + "." + profiler$result.field_76331_c, indent + 1, dest);
            }
        }
    }

    public static interface ILogAcceptor<E extends Throwable> {
        public void write(String var1) throws E;
    }
}

