/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.lib.misc.ArrayUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.ChangingObject;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public final class ChangingItemStack
extends ChangingObject<ItemStack> {
    public ChangingItemStack(NonNullList<ItemStack> stacks) {
        super(stacks.toArray((Object[])new ItemStack[0]));
    }

    public ChangingItemStack(@Nonnull Ingredient ingredient) {
        super(ChangingItemStack.makeRecipeArray(ingredient));
    }

    public ChangingItemStack(ItemStack stack) {
        super(ChangingItemStack.makeStackArray(stack));
    }

    public ChangingItemStack(String oreId) {
        this((NonNullList<ItemStack>)OreDictionary.getOres((String)oreId));
    }

    private static ItemStack[] makeStackArray(ItemStack stack) {
        if (stack.func_190926_b()) {
            return new ItemStack[]{ItemStack.field_190927_a};
        }
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            NonNullList subs = NonNullList.func_191196_a();
            stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subs);
            return (ItemStack[])subs.toArray((Object[])new ItemStack[0]);
        }
        return new ItemStack[]{stack};
    }

    private static ItemStack[] makeRecipeArray(Ingredient ingredient) {
        ItemStack[] stacks = ingredient.func_193365_a();
        if (stacks.length == 0) {
            return new ItemStack[]{ItemStack.field_190927_a};
        }
        return (ItemStack[])stacks.clone();
    }

    @Override
    protected int computeHash() {
        return ArrayUtil.manualHash(this.options, StackUtil::hash);
    }

    public boolean matches(ItemStack target) {
        for (ItemStack s : (ItemStack[])this.options) {
            if (!StackUtil.isCraftingEquivalent(s, target, false)) continue;
            return true;
        }
        return false;
    }
}

