/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.statements.StatementManager;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.transport.pipe.behaviour.PipeBehaviourEmzuli;
import buildcraft.transport.statements.ActionExtractionPreset;
import buildcraft.transport.statements.ActionParameterSignal;
import buildcraft.transport.statements.ActionPipeColor;
import buildcraft.transport.statements.ActionPipeDirection;
import buildcraft.transport.statements.ActionPipeSignal;
import buildcraft.transport.statements.ActionProviderPipes;
import buildcraft.transport.statements.TriggerParameterSignal;
import buildcraft.transport.statements.TriggerPipeSignal;
import buildcraft.transport.statements.TriggerProviderPipes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;

public class BCTransportStatements {
    public static final TriggerPipeSignal[] TRIGGER_PIPE_SIGNAL = new TriggerPipeSignal[2 * ColourUtil.COLOURS.length];
    public static final ActionPipeSignal[] ACTION_PIPE_SIGNAL;
    public static final ActionPipeColor[] ACTION_PIPE_COLOUR;
    public static final ActionExtractionPreset[] ACTION_EXTRACTION_PRESET;
    public static final ActionPipeDirection[] ACTION_PIPE_DIRECTION;

    public static void preInit() {
        StatementManager.registerTriggerProvider(TriggerProviderPipes.INSTANCE);
        StatementManager.registerActionProvider(ActionProviderPipes.INSTANCE);
    }

    static {
        for (EnumDyeColor enumDyeColor : ColourUtil.COLOURS) {
            BCTransportStatements.TRIGGER_PIPE_SIGNAL[enumDyeColor.ordinal() * 2 + 0] = new TriggerPipeSignal(true, enumDyeColor);
            BCTransportStatements.TRIGGER_PIPE_SIGNAL[enumDyeColor.ordinal() * 2 + 1] = new TriggerPipeSignal(false, enumDyeColor);
        }
        ACTION_PIPE_SIGNAL = new ActionPipeSignal[ColourUtil.COLOURS.length];
        for (EnumDyeColor enumDyeColor : ColourUtil.COLOURS) {
            BCTransportStatements.ACTION_PIPE_SIGNAL[enumDyeColor.ordinal()] = new ActionPipeSignal(enumDyeColor);
        }
        ACTION_PIPE_COLOUR = new ActionPipeColor[ColourUtil.COLOURS.length];
        for (EnumDyeColor enumDyeColor : ColourUtil.COLOURS) {
            BCTransportStatements.ACTION_PIPE_COLOUR[enumDyeColor.ordinal()] = new ActionPipeColor(enumDyeColor);
        }
        ACTION_EXTRACTION_PRESET = new ActionExtractionPreset[PipeBehaviourEmzuli.SlotIndex.VALUES.length];
        for (PipeBehaviourEmzuli.SlotIndex slotIndex : PipeBehaviourEmzuli.SlotIndex.VALUES) {
            BCTransportStatements.ACTION_EXTRACTION_PRESET[slotIndex.ordinal()] = new ActionExtractionPreset(slotIndex);
        }
        ACTION_PIPE_DIRECTION = new ActionPipeDirection[EnumFacing.field_82609_l.length];
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            BCTransportStatements.ACTION_PIPE_DIRECTION[enumFacing.ordinal()] = new ActionPipeDirection(enumFacing);
        }
        StatementManager.registerParameter(TriggerParameterSignal::readFromNbt, TriggerParameterSignal::readFromBuf);
        StatementManager.registerParameter(ActionParameterSignal::readFromNbt);
    }
}

